/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryConstructorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("RedundantNoArgConstructor" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryConstructorInspection.getID must not return null");
        }
        return "RedundantNoArgConstructor";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryConstructorInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryConstructorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryConstructorFix();
    }

    private static class UnnecessaryConstructorVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiStatement statement;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorVisitor.visitClass must not be null");
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length != 1) {
                return;
            }
            PsiMethod constructor = constructors[0];
            if (!constructor.hasModifierProperty("private") && aClass.hasModifierProperty("private")) {
                return;
            }
            if (!constructor.hasModifierProperty("packageLocal") && aClass.hasModifierProperty("packageLocal")) {
                return;
            }
            if (!constructor.hasModifierProperty("protected") && aClass.hasModifierProperty("protected")) {
                return;
            }
            if (!constructor.hasModifierProperty("public") && aClass.hasModifierProperty("public")) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiReferenceList throwsList = constructor.getThrowsList();
            PsiJavaCodeReferenceElement[] elements = throwsList.getReferenceElements();
            if (elements.length != 0) {
                return;
            }
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                this.registerMethodError(constructor, new Object[0]);
            } else if (statements.length == 1 && "super();".equals((statement = statements[0]).getText())) {
                this.registerMethodError(constructor, new Object[0]);
            }
        }
    }

    private static class UnnecessaryConstructorFix
    extends InspectionGadgetsFix {
        private UnnecessaryConstructorFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.constructor.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement nameIdentifier = descriptor.getPsiElement();
            PsiElement constructor = nameIdentifier.getParent();
            assert (constructor != null);
            UnnecessaryConstructorFix.deleteElement(constructor);
        }
    }
}

