/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class UnnecessarySuperConstructorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("UnnecessaryCallToSuper" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessarySuperConstructorInspection.getID must not return null");
        }
        return "UnnecessaryCallToSuper";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.super.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessarySuperConstructorInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.super.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessarySuperConstructorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarySuperConstructorFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySuperConstructorVisitor();
    }

    private static class UnnecessarySuperConstructorVisitor
    extends BaseInspectionVisitor {
        private UnnecessarySuperConstructorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnnecessarySuperConstructorInspection$UnnecessarySuperConstructorVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodText = methodExpression.getText();
            if (!"super".equals(methodText)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 0) {
                return;
            }
            this.registerError((PsiElement)call, new Object[0]);
        }
    }

    private static class UnnecessarySuperConstructorFix
    extends InspectionGadgetsFix {
        private UnnecessarySuperConstructorFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.super.constructor.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessarySuperConstructorInspection$UnnecessarySuperConstructorFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement superCall = descriptor.getPsiElement();
            PsiElement callStatement = superCall.getParent();
            assert (callStatement != null);
            UnnecessarySuperConstructorFix.deleteElement(callStatement);
        }
    }
}

