/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.generate.tostring.GenerateToStringContext;
import org.jetbrains.generate.tostring.GenerateToStringUtils;
import org.jetbrains.generate.tostring.inspection.AbstractGenerateToStringQuickFix;
import org.jetbrains.generate.tostring.inspection.AbstractToStringInspection;
import org.jetbrains.generate.tostring.inspection.GenerateToStringQuickFix;
import org.jetbrains.generate.tostring.psi.PsiAdapter;
import org.jetbrains.generate.tostring.psi.PsiAdapterFactory;

public class FieldNotUsedInToStringInspection
extends AbstractToStringInspection {
    private final AbstractGenerateToStringQuickFix fix = new GenerateToStringQuickFix();

    @NotNull
    public String getDisplayName() {
        if ("Field not used in toString() method" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/generate/tostring/inspection/FieldNotUsedInToStringInspection.getDisplayName must not return null");
        }
        return "Field not used in toString() method";
    }

    @NotNull
    public String getShortName() {
        if ("FieldNotUsedInToString" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/generate/tostring/inspection/FieldNotUsedInToStringInspection.getShortName must not return null");
        }
        return "FieldNotUsedInToString";
    }

    public boolean runForWholeFile() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/generate/tostring/inspection/FieldNotUsedInToStringInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitClass(PsiClass clazz) {
                FieldNotUsedInToStringInspection.this.checkFields(holder, clazz);
                FieldNotUsedInToStringInspection.this.checkMethods(holder, clazz);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/generate/tostring/inspection/FieldNotUsedInToStringInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    private void checkFields(ProblemsHolder holder, PsiClass clazz) {
        if (log.isDebugEnabled()) {
            log.debug("checkFields: clazz=" + clazz);
        }
        if (clazz == null || clazz.getName() == null) {
            return;
        }
        PsiAdapter psi = PsiAdapterFactory.getPsiAdapter();
        PsiField[] fields = clazz.getFields();
        if (fields.length == 0) {
            log.debug("Class does not have any fields");
            return;
        }
        PsiMethod toStringMethod = psi.findMethodByName(clazz, "toString");
        if (toStringMethod == null) {
            log.debug("No toString() method");
            return;
        }
        PsiCodeBlock code = toStringMethod.getBody();
        if (code == null) {
            log.debug("No toString() code");
            return;
        }
        String body = code.getText();
        if (body.indexOf("getDeclaredFields()") != -1) {
            log.debug("Using reflection");
            return;
        }
        if (body.indexOf("ReflectionToStringBuilder(this).toString()") != -1) {
            log.debug("Using reflection (ReflectionToStringBuilder)");
            return;
        }
        Project project = clazz.getProject();
        fields = GenerateToStringUtils.filterAvailableFields(project, psi, clazz, GenerateToStringContext.getConfig().getFilterPattern());
        if (fields == null || fields.length == 0) {
            log.debug("No fields to be dumped as all fields was excluded (exclude field by XXX from Settings)");
            return;
        }
        for (PsiField field : fields) {
            if (log.isDebugEnabled()) {
                log.debug("Evaluating if field " + field.getName() + " is in toString() method");
            }
            String pattern = "(?s).*\\W" + field.getName() + "[\\W&&[^=]].*";
            if (log.isDebugEnabled()) {
                log.debug("Match pattern = " + pattern);
            }
            if (body.matches(pattern)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Field is not used in toString() method (out-of-sync): " + field);
            }
            holder.registerProblem((PsiElement)field, "Field '" + field.getName() + "' is not used in toString() method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.fix});
        }
    }

    private void checkMethods(ProblemsHolder holder, PsiClass clazz) {
        if (log.isDebugEnabled()) {
            log.debug("checkMethods: clazz=" + clazz);
        }
        if (clazz == null || clazz.getName() == null) {
            return;
        }
        if (!GenerateToStringContext.getConfig().isEnableMethods()) {
            return;
        }
        PsiAdapter psi = PsiAdapterFactory.getPsiAdapter();
        PsiMethod toStringMethod = psi.findMethodByName(clazz, "toString");
        if (toStringMethod == null) {
            log.debug("No toString() method");
            return;
        }
        PsiCodeBlock code = toStringMethod.getBody();
        if (code == null) {
            log.debug("No toString() code");
            return;
        }
        String body = code.getText();
        if (body.indexOf("getDeclaredFields()") != -1) {
            log.debug("Using reflection");
            return;
        }
        PsiMethod[] methods = clazz.getMethods();
        if (methods.length == 0) {
            log.debug("Class does not have any methods");
            return;
        }
        methods = GenerateToStringUtils.filterAvailableMethods(psi, clazz, GenerateToStringContext.getConfig().getFilterPattern());
        if (methods == null || methods.length == 0) {
            log.debug("No getter methods to be dumped as all methods was excluded or a field existed for the getter method (exclude method by XXX from Settings)");
            return;
        }
        for (PsiMethod method : methods) {
            if (log.isDebugEnabled()) {
                log.debug("Evaluating if method " + method.getName() + " is in toString() method");
            }
            String pattern = "(?s).*\\W" + method.getName() + "[\\W&&[^=]].*";
            if (log.isDebugEnabled()) {
                log.debug("Match pattern = " + pattern);
            }
            if (body.matches(pattern)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Getter method is not used in toString() method (out-of-sync): " + method);
            }
            holder.registerProblem((PsiElement)method, "Method '" + method.getName() + "' is not used in toString() method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.fix});
        }
    }
}

