/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.merge;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.merge.MergeDataProvider;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CompositeOperaton;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.GetFileContentOperation;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.SimpleRevision;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SelectFromListDialog;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergeInfo
implements MergeDataProvider {
    private final boolean myUseLocal;
    private final String myResultRevision;
    private final String myOriginalRevision;
    private final String myLastRevision;
    private final VirtualFile myFile;
    private final Project myProject;

    public MergeInfo(boolean useLocal, String resultRevision, String originalRevision, String lastRevision, VirtualFile file, Project project) {
        this.myUseLocal = useLocal;
        this.myResultRevision = resultRevision;
        this.myOriginalRevision = originalRevision;
        this.myLastRevision = lastRevision;
        this.myFile = file;
        this.myProject = project;
    }

    private boolean isUseStoredRevision() {
        return this.myUseLocal;
    }

    private String getOriginalRevision() {
        return this.myOriginalRevision;
    }

    private String getLastRevision() {
        return this.myLastRevision;
    }

    private String getResultRevision() {
        return this.myResultRevision;
    }

    @Override
    @NotNull
    public MergeData createData() throws VcsException {
        MergeData mergeData = this.loadRevisionsInternal(this.getOriginalRevision(), this.getLastRevision());
        if (mergeData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/actions/merge/MergeInfo.createData must not return null");
        }
        return mergeData;
    }

    private VirtualFile[] getStoredFiles() {
        VirtualFile[] children;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        String prefix = ".#" + this.myFile.getName() + ".";
        VirtualFile parent = this.myFile.getParent();
        if (parent != null && (children = parent.getChildren()) != null) {
            for (VirtualFile child : children) {
                if (!child.getName().startsWith(prefix)) continue;
                result.add(child);
            }
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    @Nullable
    private byte[] getStoredContent() throws VcsException {
        try {
            if (this.isUseStoredRevision()) {
                String revision = this.getResultRevision();
                byte[] result = CvsUtil.getStoredContentForFile(this.myFile, revision);
                if (result != null) {
                    return result;
                }
                VirtualFile[] storedFiles = this.getStoredFiles();
                if (storedFiles.length == 0) {
                    Messages.showMessageDialog((String)CvsBundle.message((String)"message.error.cannot.find.storing.copy", (Object[])new Object[]{this.myFile.getName()}), (String)CvsBundle.getMergeOperationName(), (Icon)Messages.getErrorIcon());
                    return null;
                }
                if (storedFiles.length == 1) {
                    VirtualFile storedCopy = storedFiles[0];
                    if (Messages.showYesNoDialog((String)CvsBundle.message((String)"message.confirmation.use.stored.copy.for.merge", (Object[])new Object[]{storedCopy.getPath()}), (String)CvsBundle.getMergeOperationName(), (Icon)Messages.getQuestionIcon()) != 0) {
                        return null;
                    }
                    return storedCopy.contentsToByteArray();
                }
                VirtualFile selected = this.chooseFileFrom(storedFiles);
                if (selected == null) {
                    return null;
                }
                return selected.contentsToByteArray();
            }
            try {
                GetFileContentOperation operation = GetFileContentOperation.createForFile(this.myFile, new SimpleRevision(this.getResultRevision()));
                CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
                executor.performActionSync(new CommandCvsHandler(CvsBundle.getMergeOperationName(), operation), new CvsOperationExecutorCallback(){

                    @Override
                    public void executionFinished(boolean successfully) {
                    }

                    @Override
                    public void executeInProgressAfterAction(ModalityContext modaityContext) {
                    }

                    @Override
                    public void executionFinishedSuccessfully() {
                    }
                });
                return operation.getFileBytes();
            }
            catch (CannotFindCvsRootException e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Nullable
    private VirtualFile chooseFileFrom(VirtualFile[] storedFiles) {
        SelectFromListDialog selectFromListDialog = new SelectFromListDialog(this.myProject, (Object[])storedFiles, new SelectFromListDialog.ToStringAspect(){

            public String getToStirng(Object obj) {
                return ((VirtualFile)obj).getName();
            }
        }, CvsBundle.message((String)"message.choose.stored.file.version.title", (Object[])new Object[0]), 0);
        selectFromListDialog.show();
        if (!selectFromListDialog.isOK()) {
            return null;
        }
        return (VirtualFile)selectFromListDialog.getSelection()[0];
    }

    @NotNull
    private MergeData loadRevisionsInternal(String firstRevision, String secondRevision) throws VcsException {
        MergeData mergeData;
        try {
            SimpleRevision firstRevisionNumber = new SimpleRevision(firstRevision);
            GetFileContentOperation fileToMergeWithContentOperation = GetFileContentOperation.createForFile(this.myFile, firstRevisionNumber);
            GetFileContentOperation originalFileContentOperation = GetFileContentOperation.createForFile(this.myFile, new SimpleRevision(secondRevision));
            CompositeOperaton compositeOperaton = new CompositeOperaton();
            compositeOperaton.addOperation(fileToMergeWithContentOperation);
            compositeOperaton.addOperation(originalFileContentOperation);
            CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
            executor.performActionSync(new CommandCvsHandler(CvsBundle.getMergeOperationName(), compositeOperaton), new CvsOperationExecutorCallback(){

                @Override
                public void executionFinished(boolean successfully) {
                }

                @Override
                public void executeInProgressAfterAction(ModalityContext modaityContext) {
                }

                @Override
                public void executionFinishedSuccessfully() {
                }
            });
            MergeData result = new MergeData();
            result.CURRENT = this.getStoredContent();
            result.ORIGINAL = originalFileContentOperation.getFileBytes();
            result.LAST = fileToMergeWithContentOperation.getFileBytes();
            result.LAST_REVISION_NUMBER = firstRevisionNumber.getCvsRevisionNumber();
            mergeData = result;
        }
        catch (CannotFindCvsRootException e) {
            throw new VcsException((Throwable)e);
        }
        if (mergeData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/cvsSupport2/actions/merge/MergeInfo.loadRevisionsInternal must not return null");
        }
        return mergeData;
    }
}

