/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.changeBrowser;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.log.Revision;

class RevisionWrapper
implements Comparable<RevisionWrapper> {
    private final String myFile;
    private final Revision myRevision;
    private final String myBranch;
    private final long myTime;

    public RevisionWrapper(String file, @NotNull Revision revision, @Nullable String branch) {
        if (revision == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/cvsSupport2/changeBrowser/RevisionWrapper.<init> must not be null");
        }
        this.myFile = file;
        this.myRevision = revision;
        this.myTime = revision.getDate().getTime();
        this.myBranch = branch;
    }

    @Override
    public int compareTo(RevisionWrapper o) {
        return (int)(this.myTime - o.myTime);
    }

    public String getFile() {
        return this.myFile;
    }

    public Revision getRevision() {
        return this.myRevision;
    }

    public long getTime() {
        return this.myTime;
    }

    public String getBranch() {
        return this.myBranch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevisionWrapper that = (RevisionWrapper)o;
        if (this.myTime != that.myTime) {
            return false;
        }
        if (!this.myFile.equals(that.myFile)) {
            return false;
        }
        return this.myRevision.getNumber().equals(that.myRevision.getNumber());
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myRevision.getNumber().hashCode();
        result = 31 * result + (int)(this.myTime ^ this.myTime >>> 32);
        return result;
    }

    public void writeToStream(DataOutput stream) throws IOException {
        stream.writeUTF(this.myFile);
        stream.writeUTF(this.myRevision.getNumber());
        stream.writeLong(this.myRevision.getDate().getTime());
        stream.writeUTF(this.myRevision.getAuthor());
        stream.writeUTF(this.myRevision.getState());
        String lines = this.myRevision.getLines();
        stream.writeUTF(lines == null ? "" : lines);
        stream.writeUTF(this.myRevision.getMessage());
        String branches = this.myRevision.getBranches();
        stream.writeUTF(branches == null ? "" : branches);
        stream.writeUTF(this.myBranch == null ? "" : this.myBranch);
    }

    public static RevisionWrapper readFromStream(DataInput stream) throws IOException {
        String branch;
        String file = stream.readUTF();
        String number = stream.readUTF();
        Revision revision = new Revision(number);
        long time = stream.readLong();
        revision.setDate(new Date(time));
        revision.setAuthor(stream.readUTF());
        revision.setState(stream.readUTF());
        String lines = stream.readUTF();
        if (lines.length() > 0) {
            revision.setLines(lines);
        }
        revision.setMessage(stream.readUTF());
        String branches = stream.readUTF();
        if (branches.length() > 0) {
            revision.setBranches(branches);
        }
        return new RevisionWrapper(file, revision, (branch = stream.readUTF()).length() > 0 ? branch : null);
    }
}

