/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.checkinProject;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.RestoreFileAction;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextAdapter;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;

public class CvsRollbacker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.checkinProject.CvsRollbacker");
    private final Project myProject;

    public CvsRollbacker(Project project) {
        this.myProject = project;
    }

    public boolean rollbackFileModifying(VirtualFile parent, String name) {
        return this.restoreFile(parent, name);
    }

    public boolean rollbackFileDeleting(VirtualFile parent, String name) {
        return this.restoreFile(parent, name);
    }

    public static boolean rollbackFileCreating(VirtualFile parent, String name) throws IOException {
        CvsUtil.removeEntryFor(CvsVfsUtil.getFileFor(parent, name));
        return true;
    }

    private boolean restoreFile(VirtualFile parent, String name) {
        try {
            new RestoreFileAction(parent, name).actionPerformed(this.createDataContext());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return false;
        }
        return true;
    }

    private CvsContext createDataContext() {
        return new CvsContextAdapter(){

            @Override
            public Project getProject() {
                return CvsRollbacker.this.myProject;
            }
        };
    }
}

