/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsContent;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.common.RepositoryPathProvider;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContent;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentListener;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentProvider;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminReaderOnStoredRepositoryPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;

public class GetDirectoriesListViaUpdateOperation
extends LocalPathIndifferentOperation
implements DirectoryContentProvider {
    private final DirectoryContentListener myDirectoryContentListener = new DirectoryContentListener();
    private Consumer<DirectoryContent> myStepByStepListener;

    public GetDirectoriesListViaUpdateOperation(CvsEnvironment env, String parentDirectoryName) {
        super((IAdminReader)new AdminReaderOnStoredRepositoryPath(GetDirectoriesListViaUpdateOperation.createRepositoryPathProvider(parentDirectoryName)), env);
    }

    public static RepositoryPathProvider createRepositoryPathProvider(final String parentDirName) {
        return new RepositoryPathProvider(){

            @Override
            public String getRepositoryPath(String repository) {
                String result = repository;
                if (!StringUtil.endsWithChar((CharSequence)result, (char)'/')) {
                    result = result + "/";
                }
                return result + parentDirName;
            }
        };
    }

    @Override
    public void modifyOptions(GlobalOptions options) {
        super.modifyOptions(options);
        options.setDoNoChanges(true);
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        UpdateCommand command = new UpdateCommand();
        command.setBuildDirectories(true);
        root.getRevisionOrDate().setForCommand((Command)command);
        command.setRecursive(true);
        return command;
    }

    @Override
    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        DirectoryContentListener tmp = new DirectoryContentListener();
        tmp.messageSent(message);
        DirectoryContent tmpContent = tmp.getDirectoryContent();
        DirectoryContent mainContent = this.myDirectoryContentListener.getDirectoryContent();
        if (!(mainContent.getFiles().containsAll(tmpContent.getFiles()) && mainContent.getSubDirectories().containsAll(tmpContent.getSubDirectories()) && mainContent.getSubModules().containsAll(tmpContent.getSubModules()))) {
            this.myDirectoryContentListener.getDirectoryContent().copyDataFrom(tmpContent);
            if (this.myStepByStepListener != null) {
                this.myStepByStepListener.consume((Object)tmpContent);
            }
        }
    }

    @Override
    public DirectoryContent getDirectoryContent() {
        return this.myDirectoryContentListener.getDirectoryContent();
    }

    @Override
    protected String getOperationName() {
        return "update";
    }

    public void setStepByStepListener(Consumer<DirectoryContent> stepByStepListener) {
        this.myStepByStepListener = stepByStepListener;
    }
}

