/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsUpdate.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsHelper;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsProviderOnVirtualFiles;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.ui.DateOrRevisionOrTagSettings;
import com.intellij.cvsSupport2.ui.ChangeKeywordSubstitutionPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class UpdateOptionsPanel {
    private JCheckBox myPruneEmptyDirectories;
    private TextFieldWithBrowseButton myBranch;
    private TextFieldWithBrowseButton myBranch2;
    private JCheckBox mySwitchToHeadRevision;
    private JCheckBox myCreateNewDirectories;
    private JCheckBox myCleanCopy;
    private JPanel myDateOrRevisionPanel;
    private final ChangeKeywordSubstitutionPanel myChangeKeywordSubstitutionPanel;
    private final DateOrRevisionOrTagSettings myDateOrRevisionOrTagSettings;
    private JPanel myPanel;
    private JPanel myKeywordSubstitutionPanel;
    private JRadioButton myDoNotMerge;
    private JRadioButton myMergeWithBranch;
    private JRadioButton myMergeTwoBranches;
    private final JRadioButton[] myMergingGroup;
    private final Project myProject;

    public UpdateOptionsPanel(Project project, Collection<FilePath> files) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myChangeKeywordSubstitutionPanel = new ChangeKeywordSubstitutionPanel(CvsConfiguration.getInstance((Project)this.myProject).UPDATE_KEYWORD_SUBSTITUTION);
        CvsConfiguration.getInstance((Project)this.myProject).CLEAN_COPY = false;
        CvsConfiguration.getInstance((Project)this.myProject).RESET_STICKY = false;
        this.myMergingGroup = new JRadioButton[]{this.myDoNotMerge, this.myMergeWithBranch, this.myMergeTwoBranches};
        this.myKeywordSubstitutionPanel.setLayout(new BorderLayout());
        this.myKeywordSubstitutionPanel.add(this.myChangeKeywordSubstitutionPanel.getPanel(), "Center");
        this.myDateOrRevisionOrTagSettings = new DateOrRevisionOrTagSettings(new TagsProviderOnVirtualFiles(files), project, false);
        this.myDateOrRevisionOrTagSettings.setHeadCaption(CvsBundle.message((String)"label.default.update.branch", (Object[])new Object[0]));
        this.myDateOrRevisionPanel.setLayout(new BorderLayout());
        this.myDateOrRevisionPanel.add((Component)this.myDateOrRevisionOrTagSettings.getPanel(), "Center");
        TagsHelper.addChooseBranchAction(this.myBranch, files, project);
        TagsHelper.addChooseBranchAction(this.myBranch2, files, project);
    }

    public void reset() {
        CvsConfiguration config = CvsConfiguration.getInstance(this.myProject);
        this.myPruneEmptyDirectories.setSelected(config.PRUNE_EMPTY_DIRECTORIES);
        this.myDoNotMerge.setSelected(true);
        this.myBranch.setText(config.MERGE_WITH_BRANCH1_NAME);
        this.myBranch2.setText(config.MERGE_WITH_BRANCH2_NAME);
        this.mySwitchToHeadRevision.setSelected(false);
        this.myCreateNewDirectories.setSelected(config.CREATE_NEW_DIRECTORIES);
        this.myCleanCopy.setSelected(false);
        this.myDateOrRevisionOrTagSettings.updateFrom(config.UPDATE_DATE_OR_REVISION_SETTINGS);
        for (JRadioButton jRadioButton : this.myMergingGroup) {
            jRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    UpdateOptionsPanel.this.enableBranchField();
                }
            });
        }
        this.enableBranchField();
    }

    private void enableBranchField() {
        int mergingMode = UpdateOptionsPanel.getSelected(this.myMergingGroup);
        switch (mergingMode) {
            case 0: {
                this.myBranch.setEnabled(false);
                this.myBranch2.setEnabled(false);
                return;
            }
            case 1: {
                this.myBranch.setEnabled(true);
                this.myBranch2.setEnabled(false);
                return;
            }
            case 2: {
                this.myBranch.setEnabled(true);
                this.myBranch2.setEnabled(true);
                return;
            }
        }
    }

    public void apply() {
        CvsConfiguration configuration = CvsConfiguration.getInstance(this.myProject);
        configuration.CLEAN_COPY = false;
        if (this.myCleanCopy.isSelected() && Messages.showYesNoDialog((String)CvsBundle.message((String)"confirmation.clean.copy", (Object[])new Object[0]), (String)CvsBundle.message((String)"confirmation.title.clean.copy", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) == 0) {
            configuration.CLEAN_COPY = true;
        }
        configuration.PRUNE_EMPTY_DIRECTORIES = this.myPruneEmptyDirectories.isSelected();
        configuration.MERGING_MODE = UpdateOptionsPanel.getSelected(this.myMergingGroup);
        configuration.MERGE_WITH_BRANCH1_NAME = this.myBranch.getText();
        configuration.MERGE_WITH_BRANCH2_NAME = this.myBranch2.getText();
        configuration.RESET_STICKY = this.mySwitchToHeadRevision.isSelected();
        configuration.CREATE_NEW_DIRECTORIES = this.myCreateNewDirectories.isSelected();
        configuration.UPDATE_KEYWORD_SUBSTITUTION = this.myChangeKeywordSubstitutionPanel.getKeywordSubstitution();
        this.myDateOrRevisionOrTagSettings.saveTo(configuration.UPDATE_DATE_OR_REVISION_SETTINGS);
    }

    private static int getSelected(JRadioButton[] mergingGroup) {
        for (int i = 0; i < mergingGroup.length; ++i) {
            JRadioButton jRadioButton = mergingGroup[i];
            if (!jRadioButton.isSelected()) continue;
            return i;
        }
        return 0;
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(6, 6, 6, 6), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 5, 5), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("border.title.branch.merging"), 0, 0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDoNotMerge = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.update.options.dont.merge"));
        jPanel6.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMergeWithBranch = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.update.options.merge.with.branch.(-j)"));
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMergeTwoBranches = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.update.options.merge.two.branches"));
        jPanel6.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myBranch = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myBranch2 = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDateOrRevisionPanel = jPanel2 = new JPanel();
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myKeywordSubstitutionPanel = jPanel = new JPanel();
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel4.add((Component)jPanel9, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySwitchToHeadRevision = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbo.update.options.reset.sticky.data"));
        jPanel9.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPruneEmptyDirectories = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbo.update.options.prune.empty.directories"));
        jPanel9.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCreateNewDirectories = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbo.update.options.create.new.directories"));
        jPanel9.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCleanCopy = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbox.update.options.clean.copy.m"));
        jCheckBox.setLabel(ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("checkbo.update.options.clean.copy"));
        jPanel9.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

