/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.util;

import com.intellij.openapi.util.io.FileUtil;

public class PathUtil {
    public static final String UNRESOLVED_PREFIX = "?";
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";

    public static String normalize(String path) {
        int slashIndex;
        int index;
        if ((path = FileUtil.toSystemIndependentName((String)path)).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.contains("/./")) {
            path = path.replace("/./", "/");
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 2);
        }
        while ((index = path.indexOf("/..")) >= 0 && (slashIndex = path.substring(0, index).lastIndexOf("/")) >= 0) {
            path = path.substring(0, slashIndex) + path.substring(index + 3);
        }
        return path;
    }

    public static String getRelative(String baseRoot, String path) {
        int prefix = PathUtil.findCommonPathPrefixLength(baseRoot = PathUtil.normalize(baseRoot), path = PathUtil.normalize(path));
        if (prefix != 0) {
            baseRoot = baseRoot.substring(prefix);
            path = path.substring(prefix);
            if (baseRoot.length() != 0) {
                return PathUtil.normalize(PathUtil.revertRelativePath(baseRoot.substring(1)) + path);
            }
            if (path.length() != 0) {
                return path.substring(1);
            }
            return ".";
        }
        if (FileUtil.isAbsolute((String)path)) {
            return path;
        }
        return PathUtil.normalize(PathUtil.revertRelativePath(baseRoot) + "/" + path);
    }

    public static int findCommonPathPrefixLength(String path1, String path2) {
        int beg;
        int new_end;
        int end = -1;
        while ((new_end = PathUtil.endOfToken(path1, beg = end + 1)) == PathUtil.endOfToken(path2, beg) && path1.substring(beg, new_end).equals(path2.substring(beg, new_end)) && (end = new_end) != path1.length()) {
        }
        return end < 0 ? 0 : end;
    }

    private static int endOfToken(String s, int index) {
        return (index = s.indexOf("/", index)) == -1 ? s.length() : index;
    }

    private static String revertRelativePath(String path) {
        if (path.equals(".")) {
            return path;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("..");
        int count = PathUtil.normalize(path).split("/").length;
        while (--count > 0) {
            sb.append("/..");
        }
        return sb.toString();
    }
}

