/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.sonatype.nexus.index.ArtifactInfo;

public abstract class MavenSearcher<RESULT_TYPE extends MavenArtifactSearchResult> {
    public List<RESULT_TYPE> search(Project project, String pattern, int maxResult) {
        Pair<String, Query> patternAndQuery = this.preparePatternAndQuery(pattern);
        MavenProjectIndicesManager m = MavenProjectIndicesManager.getInstance(project);
        Set<ArtifactInfo> infos = m.search((Query)patternAndQuery.second, maxResult);
        ArrayList<RESULT_TYPE> result = new ArrayList<RESULT_TYPE>(this.processResults(infos, (String)patternAndQuery.first, maxResult));
        this.sort(result);
        return result;
    }

    protected abstract Pair<String, Query> preparePatternAndQuery(String var1);

    protected abstract Collection<RESULT_TYPE> processResults(Set<ArtifactInfo> var1, String var2, int var3);

    private void sort(List<RESULT_TYPE> result) {
        for (MavenArtifactSearchResult each : result) {
            Collections.sort(each.versions, ArtifactInfo.VERSION_COMPARATOR);
        }
        Collections.sort(result, new Comparator<RESULT_TYPE>(){

            @Override
            public int compare(RESULT_TYPE o1, RESULT_TYPE o2) {
                return MavenSearcher.this.makeSortKey(o1).compareTo(MavenSearcher.this.makeSortKey(o2));
            }
        });
    }

    protected String makeSortKey(RESULT_TYPE result) {
        return this.makeKey(((MavenArtifactSearchResult)result).versions.get(0));
    }

    protected String makeKey(ArtifactInfo result) {
        return result.groupId + ":" + result.artifactId;
    }
}

