/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseLineListener;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitRebaseActionBase
extends GitRepositoryAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        String messageId;
        boolean isError;
        GitRebaseLineListener.Result result;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitRebaseActionBase.perform must not be null");
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/GitRebaseActionBase.perform must not be null");
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitRebaseActionBase.perform must not be null");
        }
        GitLineHandler h = this.createHandler(project, gitRoots, defaultRoot);
        if (h == null) {
            return;
        }
        VirtualFile root = h.workingDirectoryFile();
        GitRebaseEditorService service = GitRebaseEditorService.getInstance();
        GitInteractiveRebaseEditorHandler editor = new GitInteractiveRebaseEditorHandler(service, project, root, h);
        GitRebaseLineListener resultListener = new GitRebaseLineListener();
        h.addLineListener(resultListener);
        this.configureEditor(editor);
        affectedRoots.add(root);
        try {
            service.configureHandler(h, editor.getHandlerNo());
            GitHandlerUtil.doSynchronously(h, GitBundle.getString("rebasing.title"), h.printableCommandLine());
            editor.close();
            result = resultListener.getResult();
            isError = true;
        }
        catch (Throwable throwable) {
            String messageId2;
            editor.close();
            GitRebaseLineListener.Result result2 = resultListener.getResult();
            boolean isError2 = true;
            switch (result2.status) {
                case CONFLICT: {
                    messageId2 = "rebase.result.conflict";
                    break;
                }
                case ERROR: {
                    messageId2 = "rebase.result.error";
                    break;
                }
                case CANCELLED: {
                    isError2 = false;
                    messageId2 = "rebase.result.cancelled";
                    exceptions.clear();
                    break;
                }
                case EDIT: {
                    isError2 = false;
                    messageId2 = "rebase.result.amend";
                    break;
                }
                default: {
                    messageId2 = null;
                }
            }
            if (messageId2 != null) {
                String message = GitBundle.message(messageId2, result2.current, result2.total);
                String title = GitBundle.message(messageId2 + ".title", new Object[0]);
                if (isError2) {
                    Messages.showErrorDialog((Project)project, (String)message, (String)title);
                } else {
                    Messages.showInfoMessage((Project)project, (String)message, (String)title);
                }
            }
            throw throwable;
        }
        switch (result.status) {
            case CONFLICT: {
                messageId = "rebase.result.conflict";
                break;
            }
            case ERROR: {
                messageId = "rebase.result.error";
                break;
            }
            case CANCELLED: {
                isError = false;
                messageId = "rebase.result.cancelled";
                exceptions.clear();
                break;
            }
            case EDIT: {
                isError = false;
                messageId = "rebase.result.amend";
                break;
            }
            default: {
                messageId = null;
            }
        }
        if (messageId != null) {
            String message = GitBundle.message(messageId, result.current, result.total);
            String title = GitBundle.message(messageId + ".title", new Object[0]);
            if (isError) {
                Messages.showErrorDialog((Project)project, (String)message, (String)title);
            } else {
                Messages.showInfoMessage((Project)project, (String)message, (String)title);
            }
        }
    }

    protected void configureEditor(GitInteractiveRebaseEditorHandler editor) {
    }

    @Nullable
    protected abstract GitLineHandler createHandler(Project var1, List<VirtualFile> var2, VirtualFile var3);
}

