/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.GitBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitShowAllSubmittedFilesAction;
import git4idea.checkin.GitPushRebaseProcess;
import git4idea.checkin.GitPushUtils;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitUIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GitPushActiveBranchesDialog
extends DialogWrapper {
    private static final int HASH_PREFIX_SIZE = 8;
    private JButton myViewButton;
    private JPanel myPanel;
    private JButton myFetchButton;
    private JButton myRebaseButton;
    private JCheckBox myAutoStashCheckBox;
    private CheckboxTree myCommitTree;
    private CheckedTreeNode myTreeRoot;
    private Project myProject;
    private List<VirtualFile> myVcsRoots;

    private GitPushActiveBranchesDialog(final Project project, List<VirtualFile> vcsRoots, List<Root> roots) {
        super(project, true);
        this.myProject = project;
        this.myVcsRoots = vcsRoots;
        this.$$$setupUI$$$();
        this.updateTree(roots, null);
        TreeUtil.expandAll((JTree)this.myCommitTree);
        this.myCommitTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = GitPushActiveBranchesDialog.this.myCommitTree.getSelectionModel().getSelectionPath();
                if (path == null) {
                    GitPushActiveBranchesDialog.this.myViewButton.setEnabled(false);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                GitPushActiveBranchesDialog.this.myViewButton.setEnabled(node != null && GitPushActiveBranchesDialog.this.myCommitTree.getSelectionCount() == 1 && node.getUserObject() instanceof Commit);
            }
        });
        this.myViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = GitPushActiveBranchesDialog.this.myCommitTree.getSelectionModel().getSelectionPath();
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node == null || !(node.getUserObject() instanceof Commit)) {
                    return;
                }
                Commit c = (Commit)node.getUserObject();
                GitShowAllSubmittedFilesAction.showSubmittedFiles(project, c.revision.asString(), c.root.root);
            }
        });
        this.myFetchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitPushActiveBranchesDialog.this.doFetch();
            }
        });
        this.myRebaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitPushActiveBranchesDialog.this.doRebase();
            }
        });
        this.setTitle(GitBundle.getString("push.active.title"));
        this.setOKButtonText(GitBundle.getString("push.active.button"));
        this.init();
    }

    private void doFetch() {
        HashMap<VirtualFile, Set<String>> unchecked = new HashMap<VirtualFile, Set<String>>();
        for (int i = 0; i < this.myTreeRoot.getChildCount(); ++i) {
            HashSet<String> uncheckedCommits = new HashSet<String>();
            CheckedTreeNode node = (CheckedTreeNode)this.myTreeRoot.getChildAt(i);
            Root r = (Root)node.getUserObject();
            for (int j = 0; j < node.getChildCount(); ++j) {
                CheckedTreeNode commitNode;
                if (!(node.getChildAt(j) instanceof CheckedTreeNode) || (commitNode = (CheckedTreeNode)node.getChildAt(j)).isChecked()) continue;
                uncheckedCommits.add(((Commit)commitNode.getUserObject()).commitId());
            }
            if (uncheckedCommits.isEmpty()) continue;
            unchecked.put(r.root, uncheckedCommits);
        }
        this.refreshTree(true, unchecked);
    }

    private boolean isRebaseNeeded() {
        for (int i = 0; i < this.myTreeRoot.getChildCount(); ++i) {
            CheckedTreeNode node = (CheckedTreeNode)this.myTreeRoot.getChildAt(i);
            Root r = (Root)node.getUserObject();
            if (r.commits.size() == 0) continue;
            boolean seenCheckedNode = false;
            for (int j = 0; j < node.getChildCount(); ++j) {
                if (!(node.getChildAt(j) instanceof CheckedTreeNode)) continue;
                CheckedTreeNode commitNode = (CheckedTreeNode)node.getChildAt(j);
                if (commitNode.isChecked()) {
                    seenCheckedNode = true;
                    continue;
                }
                if (!seenCheckedNode) continue;
                return true;
            }
            if (!seenCheckedNode || r.remoteCommits <= 0) continue;
            return true;
        }
        return false;
    }

    private void doRebase() {
        final HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        final HashSet<VirtualFile> rootsWithMerges = new HashSet<VirtualFile>();
        final HashMap reorderedCommits = new HashMap();
        HashMap<VirtualFile, Set<String>> uncheckedCommits = new HashMap<VirtualFile, Set<String>>();
        for (int i = 0; i < this.myTreeRoot.getChildCount(); ++i) {
            Commit commit;
            CheckedTreeNode commitNode;
            int j;
            CheckedTreeNode node = (CheckedTreeNode)this.myTreeRoot.getChildAt(i);
            Root r = (Root)node.getUserObject();
            HashSet<String> unchecked = new HashSet<String>();
            uncheckedCommits.put(r.root, unchecked);
            if (r.commits.size() == 0) continue;
            boolean seenCheckedNode = false;
            boolean reorderNeeded = false;
            boolean seenMerges = false;
            for (int j2 = 0; j2 < node.getChildCount(); ++j2) {
                if (!(node.getChildAt(j2) instanceof CheckedTreeNode)) continue;
                CheckedTreeNode commitNode2 = (CheckedTreeNode)node.getChildAt(j2);
                Commit commit2 = (Commit)commitNode2.getUserObject();
                seenMerges |= commit2.isMerge;
                if (commitNode2.isChecked()) {
                    seenCheckedNode = true;
                    continue;
                }
                unchecked.add(commit2.commitId());
                if (!seenCheckedNode) continue;
                reorderNeeded = true;
            }
            if (seenMerges) {
                rootsWithMerges.add(r.root);
            }
            if (r.remoteCommits > 0 && seenCheckedNode || reorderNeeded) {
                roots.add(r.root);
            }
            if (!reorderNeeded) continue;
            ArrayList<String> reordered = new ArrayList<String>();
            for (j = 0; j < node.getChildCount(); ++j) {
                if (!(node.getChildAt(j) instanceof CheckedTreeNode) || (commitNode = (CheckedTreeNode)node.getChildAt(j)).isChecked()) continue;
                commit = (Commit)commitNode.getUserObject();
                reordered.add(commit.revision.asString());
            }
            for (j = 0; j < node.getChildCount(); ++j) {
                if (!(node.getChildAt(j) instanceof CheckedTreeNode) || !(commitNode = (CheckedTreeNode)node.getChildAt(j)).isChecked()) continue;
                commit = (Commit)commitNode.getUserObject();
                reordered.add(commit.revision.asString());
            }
            Collections.reverse(reordered);
            reorderedCommits.put(r.root, reordered);
        }
        final ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        final boolean autoStash = this.myAutoStashCheckBox.isSelected();
        final ProgressManager progressManager = ProgressManager.getInstance();
        final GitVcs vcs = GitVcs.getInstance(this.myProject);
        progressManager.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                GitPushRebaseProcess process = new GitPushRebaseProcess(vcs, GitPushActiveBranchesDialog.this.myProject, exceptions, autoStash, reorderedCommits, rootsWithMerges);
                process.doUpdate(progressManager.getProgressIndicator(), roots);
            }
        }, GitBundle.getString("push.active.rebasing"), false, this.myProject);
        this.refreshTree(false, uncheckedCommits);
        if (!exceptions.isEmpty()) {
            GitUIUtil.showOperationErrors(this.myProject, exceptions, "git rebase");
        }
        GitUtil.refreshFiles(this.myProject, roots);
    }

    private void refreshTree(boolean fetchData, Map<VirtualFile, Set<String>> unchecked) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        List<Root> roots = GitPushActiveBranchesDialog.loadRoots(this.myProject, this.myVcsRoots, exceptions, fetchData);
        if (!exceptions.isEmpty()) {
            GitUIUtil.showOperationErrors(this.myProject, exceptions, "Refreshing root information");
            return;
        }
        this.updateTree(roots, unchecked);
    }

    private void updateTree(List<Root> roots, Map<VirtualFile, Set<String>> uncheckedCommits) {
        this.myTreeRoot.removeAllChildren();
        for (Root r : roots) {
            CheckedTreeNode rootNode = new CheckedTreeNode((Object)r);
            Status status = new Status();
            status.root = r;
            rootNode.add((MutableTreeNode)new DefaultMutableTreeNode(status, false));
            Set unchecked = uncheckedCommits != null && uncheckedCommits.containsKey(r.root) ? uncheckedCommits.get(r.root) : Collections.emptySet();
            for (Commit c : r.commits) {
                CheckedTreeNode child = new CheckedTreeNode((Object)c);
                rootNode.add((MutableTreeNode)child);
                child.setChecked(r.remote != null && !unchecked.contains(c.commitId()));
            }
            this.myTreeRoot.add((MutableTreeNode)rootNode);
        }
        ((DefaultTreeModel)this.myCommitTree.getModel()).reload((TreeNode)this.myTreeRoot);
        TreeUtil.expandAll((JTree)this.myCommitTree);
        this.updateButtons();
    }

    private void updateButtons() {
        String error = null;
        boolean wasCheckedNode = false;
        boolean reorderMerges = false;
        for (int i = 0; i < this.myTreeRoot.getChildCount(); ++i) {
            CheckedTreeNode node = (CheckedTreeNode)this.myTreeRoot.getChildAt(i);
            boolean seenCheckedNode = false;
            boolean reorderNeeded = false;
            boolean seenMerges = false;
            boolean seenUnchecked = false;
            for (int j = 0; j < node.getChildCount(); ++j) {
                if (!(node.getChildAt(j) instanceof CheckedTreeNode)) continue;
                CheckedTreeNode commitNode = (CheckedTreeNode)node.getChildAt(j);
                Commit commit = (Commit)commitNode.getUserObject();
                seenMerges |= commit.isMerge;
                if (commitNode.isChecked()) {
                    seenCheckedNode = true;
                    continue;
                }
                seenUnchecked = true;
                if (!seenCheckedNode) continue;
                reorderNeeded = true;
            }
            if (!seenCheckedNode) continue;
            Root r = (Root)node.getUserObject();
            if (seenMerges && seenUnchecked) {
                error = GitBundle.getString("push.active.error.merges.unchecked");
            }
            if (seenMerges && reorderNeeded) {
                reorderMerges = true;
                error = GitBundle.getString("push.active.error.reorder.merges");
            }
            if (reorderNeeded && error == null) {
                error = GitBundle.getString("push.active.error.reorder.needed");
            }
            if (r.branch == null) {
                if (error != null) break;
                error = GitBundle.getString("push.active.error.no.branch");
                break;
            }
            wasCheckedNode |= r.remoteBranch != null;
            if (r.remoteCommits == 0 || r.commits.size() == 0) continue;
            if (error != null) break;
            error = GitBundle.getString("push.active.error.behind");
            break;
        }
        boolean rebaseNeeded = this.isRebaseNeeded();
        this.setOKActionEnabled(wasCheckedNode && error == null && !rebaseNeeded);
        this.setErrorText(error);
        this.myRebaseButton.setEnabled(rebaseNeeded && !reorderMerges);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference?.?VersionControl?.?Git?.?PushActiveBranches";
    }

    static List<Root> loadRoots(final Project project, final List<VirtualFile> roots, final Collection<VcsException> exceptions, final boolean fetchData) {
        ProgressManager manager = ProgressManager.getInstance();
        final ArrayList<Root> rc = new ArrayList<Root>();
        manager.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile root : roots) {
                    try {
                        Root r = new Root();
                        rc.add(r);
                        r.root = root;
                        GitBranch b = GitBranch.current(project, root);
                        if (b == null) continue;
                        r.branch = b.getFullName();
                        r.remote = b.getTrackedRemoteName(project, root);
                        r.remoteBranch = b.getTrackedBranchName(project, root);
                        if (r.remote == null) continue;
                        if (fetchData && !r.remote.equals(".")) {
                            GitLineHandler fetch = new GitLineHandler(project, root, GitCommand.FETCH);
                            fetch.addParameters(r.remote, "-v");
                            Collection<VcsException> exs = GitHandlerUtil.doSynchronouslyWithExceptions(fetch);
                            exceptions.addAll(exs);
                        }
                        GitBranch tracked = b.tracked(project, root);
                        assert (tracked != null) : "Tracked branch cannot be null here";
                        GitSimpleHandler unmerged = new GitSimpleHandler(project, root, GitCommand.LOG);
                        unmerged.addParameters("--pretty=format:%H", r.branch + ".." + tracked.getFullName());
                        unmerged.setNoSSH(true);
                        unmerged.setStdoutSuppressed(true);
                        StringScanner su = new StringScanner(unmerged.run());
                        while (su.hasMoreData()) {
                            if (su.line().trim().length() == 0) continue;
                            ++r.remoteCommits;
                        }
                        GitSimpleHandler toPush = new GitSimpleHandler(project, root, GitCommand.LOG);
                        toPush.addParameters("--pretty=format:%H%x20%ct%x20%at%x20%s%n%P", tracked.getFullName() + ".." + r.branch);
                        toPush.setNoSSH(true);
                        toPush.setStdoutSuppressed(true);
                        StringScanner sp = new StringScanner(toPush.run());
                        while (sp.hasMoreData()) {
                            if (sp.isEol()) {
                                sp.line();
                                continue;
                            }
                            Commit c = new Commit();
                            c.root = r;
                            String hash = sp.spaceToken();
                            String time = sp.spaceToken();
                            c.revision = new GitRevisionNumber(hash, new Date(Long.parseLong(time) * 1000L));
                            c.authorTime = sp.spaceToken();
                            c.message = sp.line();
                            c.isMerge = sp.line().indexOf(32) != -1;
                            r.commits.add(c);
                        }
                    }
                    catch (VcsException e) {
                        exceptions.add(e);
                    }
                }
            }
        }, GitBundle.getString("push.active.fetching"), false, project);
        return rc;
    }

    public static void showDialog(final Project project, List<VirtualFile> vcsRoots, Collection<VcsException> exceptions) {
        List<Root> roots = GitPushActiveBranchesDialog.loadRoots(project, vcsRoots, exceptions, true);
        if (!exceptions.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)GitBundle.getString("push.active.fetch.failed"), (String)GitBundle.getString("push.active.fetch.failed.title"));
            return;
        }
        GitPushActiveBranchesDialog d = new GitPushActiveBranchesDialog(project, vcsRoots, roots);
        d.show();
        if (d.isOK()) {
            final ArrayList<Root> rootsToPush = new ArrayList<Root>();
            block0: for (int i = 0; i < d.myTreeRoot.getChildCount(); ++i) {
                CheckedTreeNode node = (CheckedTreeNode)d.myTreeRoot.getChildAt(i);
                Root r = (Root)node.getUserObject();
                if (r.remote == null || r.commits.size() == 0) continue;
                boolean topCommit = true;
                for (int j = 0; j < node.getChildCount(); ++j) {
                    if (!(node.getChildAt(j) instanceof CheckedTreeNode)) continue;
                    CheckedTreeNode commitNode = (CheckedTreeNode)node.getChildAt(j);
                    if (commitNode.isChecked()) {
                        Commit commit = (Commit)commitNode.getUserObject();
                        if (!topCommit) {
                            r.commitToPush = commit.revision.asString();
                        }
                        rootsToPush.add(r);
                        continue block0;
                    }
                    topCommit = false;
                }
            }
            ProgressManager manager = ProgressManager.getInstance();
            final ArrayList<VcsException> errors = new ArrayList<VcsException>();
            manager.runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    for (Root r : rootsToPush) {
                        GitLineHandler h = new GitLineHandler(project, r.root, GitCommand.PUSH);
                        String src = r.commitToPush != null ? r.commitToPush : r.branch;
                        h.addParameters("-v", r.remote, src + ":" + r.remoteBranch);
                        GitPushUtils.trackPushRejectedAsError(h, "Rejected push (" + r.root.getPresentableUrl() + "): ");
                        errors.addAll(GitHandlerUtil.doSynchronouslyWithExceptions(h));
                    }
                }
            }, GitBundle.getString("push.active.pushing"), false, project);
            if (!errors.isEmpty()) {
                GitUIUtil.showOperationErrors(project, errors, GitBundle.getString("push.active.pushing"));
            }
        }
    }

    private void createUIComponents() {
        this.myTreeRoot = new CheckedTreeNode((Object)"ROOT");
        this.myCommitTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ColoredTreeCellRenderer r = this.getTextRenderer();
                if (!(value instanceof DefaultMutableTreeNode)) {
                    this.renderUnknown(r, value);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (!(node.getUserObject() instanceof Node)) {
                    this.renderUnknown(r, node.getUserObject());
                    return;
                }
                ((Node)node.getUserObject()).render(r);
            }

            private void renderUnknown(ColoredTreeCellRenderer r, Object value) {
                r.append("UNSUPPORTED NODE TYPE: " + (value == null ? "null" : value.getClass().getName()), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }, this.myTreeRoot){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                GitPushActiveBranchesDialog.this.updateButtons();
                super.onNodeStateChanged(node);
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JCheckBox jCheckBox;
        JButton jButton3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        CheckboxTree checkboxTree = this.myCommitTree;
        jScrollPane.setViewportView((Component)checkboxTree);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.active.commits"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myViewButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.active.view"));
        ((Component)jButton3).setEnabled(false);
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myAutoStashCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.active.autostash.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.active.autostash"));
        jCheckBox.setSelected(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFetchButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.active.fetch"));
        jButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.active.fetch.tooltip"));
        jPanel2.add((Component)jButton2, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRebaseButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.active.rebase"));
        jButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("push.active.rebase.tooltip"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor(jScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    static class Root
    extends Node {
        int remoteCommits;
        VirtualFile root;
        String branch;
        String remote;
        String remoteBranch;
        String commitToPush;
        List<Commit> commits = new ArrayList<Commit>();

        Root() {
        }

        @Override
        protected void render(ColoredTreeCellRenderer renderer) {
            SimpleTextAttributes branchAttributes;
            SimpleTextAttributes rootAttributes;
            if (this.remote != null && this.commits.size() != 0 && this.remoteCommits != 0 || this.branch == null) {
                rootAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES.derive(1, null, null, null);
                branchAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            } else if (this.remote == null || this.commits.size() == 0) {
                rootAttributes = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
                branchAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            } else {
                branchAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                rootAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            renderer.append(this.root.getPresentableUrl(), rootAttributes);
            if (this.branch != null) {
                renderer.append(" [" + this.branch, branchAttributes);
                if (this.remote != null) {
                    renderer.append(" -> " + this.remote + "#" + this.remoteBranch, branchAttributes);
                }
                renderer.append("]", branchAttributes);
            }
        }
    }

    static class Commit
    extends Node {
        Root root;
        GitRevisionNumber revision;
        String message;
        String authorTime;
        boolean isMerge;

        Commit() {
        }

        @Override
        protected void render(ColoredTreeCellRenderer renderer) {
            renderer.append(this.revision.asString().substring(0, 8), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            renderer.append(": ");
            renderer.append(this.message);
            if (this.isMerge) {
                renderer.append(GitBundle.getString("push.active.commit.node.merge"), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        String commitId() {
            return this.authorTime + ":" + this.message;
        }
    }

    static class Status
    extends Node {
        Root root;

        Status() {
        }

        @Override
        protected void render(ColoredTreeCellRenderer renderer) {
            renderer.append(GitBundle.getString("push.active.status.status"));
            if (this.root.branch == null) {
                renderer.append(GitBundle.message("push.active.status.no.branch", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (this.root.remote == null) {
                renderer.append(GitBundle.message("push.active.status.no.tracked", new Object[0]), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            } else if (this.root.remoteCommits != 0 && this.root.commits.size() == 0) {
                renderer.append(GitBundle.message("push.active.status.no.commits.behind", this.root.remoteCommits), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            } else if (this.root.commits.size() == 0) {
                renderer.append(GitBundle.message("push.active.status.no.commits", new Object[0]), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            } else if (this.root.remoteCommits != 0) {
                renderer.append(GitBundle.message("push.active.status.behind", this.root.remoteCommits), SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else {
                renderer.append(GitBundle.message("push.active.status.push", this.root.commits.size()));
            }
        }
    }

    static abstract class Node {
        Node() {
        }

        protected abstract void render(ColoredTreeCellRenderer var1);
    }
}

