/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitFileUtils;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import git4idea.i18n.GitBundle;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitMergeProvider
implements MergeProvider2 {
    private static final Logger log = Logger.getInstance((String)GitMergeProvider.class.getName());
    private final Project myProject;
    @NonNls
    private static final String THEIRS_REVISION = "Theirs";
    private static final int ORIGINAL_REVISION_NUM = 1;
    private static final int YOURS_REVISION_NUM = 2;
    private static final int THEIRS_REVISION_NUM = 3;

    public GitMergeProvider(Project project) {
        this.myProject = project;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public MergeData loadRevisions(final VirtualFile file) throws VcsException {
        MergeData mergeData;
        final MergeData mergeData2 = new MergeData();
        if (file == null) {
            mergeData = mergeData2;
            if (mergeData == null) throw new IllegalStateException("@NotNull method git4idea/merge/GitMergeProvider.loadRevisions must not return null");
            return mergeData;
        }
        final FilePath path = VcsUtil.getFilePath((String)file.getPath());
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                GitFileRevision original = new GitFileRevision(GitMergeProvider.this.myProject, path, new GitRevisionNumber(":1"));
                GitFileRevision current = new GitFileRevision(GitMergeProvider.this.myProject, path, new GitRevisionNumber(":2"));
                GitFileRevision last = new GitFileRevision(GitMergeProvider.this.myProject, path, new GitRevisionNumber(":3"));
                try {
                    try {
                        mergeData2.ORIGINAL = original.getContent();
                    }
                    catch (Exception ex) {
                        mergeData2.ORIGINAL = file.contentsToByteArray();
                    }
                    mergeData2.CURRENT = current.getContent();
                    mergeData2.LAST = last.getContent();
                    mergeData2.LAST_REVISION_NUMBER = new GitRevisionNumber(GitMergeProvider.THEIRS_REVISION);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load file content", e);
                }
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)GitBundle.message("merge.load.files", new Object[0]), (boolean)false, (Project)this.myProject);
        mergeData = mergeData2;
        if (mergeData != null) return mergeData;
        throw new IllegalStateException("@NotNull method git4idea/merge/GitMergeProvider.loadRevisions must not return null");
    }

    public void conflictResolvedForFile(VirtualFile file) {
        if (file == null) {
            return;
        }
        try {
            GitFileUtils.addFiles(this.myProject, GitUtil.getGitRoot(file), file);
        }
        catch (VcsException e) {
            log.error("Confirming conflict resolution failed", (Throwable)e);
        }
    }

    public boolean isBinary(VirtualFile file) {
        return file.getFileType().isBinary();
    }

    @NotNull
    public MergeSession createMergeSession(List<VirtualFile> files) {
        MyMergeSession myMergeSession = new MyMergeSession(files);
        if (myMergeSession == null) {
            throw new IllegalStateException("@NotNull method git4idea/merge/GitMergeProvider.createMergeSession must not return null");
        }
        return myMergeSession;
    }

    private class MyMergeSession
    implements MergeSession {
        Map<VirtualFile, Conflict> myConflicts = new HashMap<VirtualFile, Conflict>();

        MyMergeSession(List<VirtualFile> filesToMerge) {
            try {
                for (Map.Entry<VirtualFile, List<VirtualFile>> e : GitUtil.sortFilesByGitRoot(filesToMerge).entrySet()) {
                    HashMap<String, Conflict> cs = new HashMap<String, Conflict>();
                    VirtualFile root = e.getKey();
                    List<VirtualFile> files = e.getValue();
                    GitSimpleHandler h = new GitSimpleHandler(GitMergeProvider.this.myProject, root, GitCommand.LS_FILES);
                    h.setNoSSH(true);
                    h.setStdoutSuppressed(true);
                    h.addParameters("--exclude-standard", "--unmerged", "-t", "-z");
                    h.endOptions();
                    String output = h.run();
                    StringScanner s = new StringScanner(output);
                    block8: while (s.hasMoreData()) {
                        if (!"M".equals(s.spaceToken())) {
                            s.boundedToken('\u0000');
                            continue;
                        }
                        s.spaceToken();
                        s.spaceToken();
                        int source = Integer.parseInt(s.tabToken());
                        String file = s.boundedToken('\u0000');
                        Conflict c = (Conflict)cs.get(file);
                        if (c == null) {
                            c = new Conflict();
                            c.myRoot = root;
                            cs.put(file, c);
                        }
                        switch (source) {
                            case 1: {
                                continue block8;
                            }
                            case 3: {
                                c.myStatusTheirs = Conflict.Status.MODIFIED;
                                continue block8;
                            }
                            case 2: {
                                c.myStatusYours = Conflict.Status.MODIFIED;
                                continue block8;
                            }
                        }
                        throw new IllegalStateException("Unknown revision " + source + " for the file: " + file);
                    }
                    for (VirtualFile f : files) {
                        String path = GitUtil.relativePath(root, f);
                        Conflict c = (Conflict)cs.get(path);
                        assert (c != null) : "The conflict not found for the file: " + f.getPath() + "(" + path + ")";
                        c.myFile = f;
                        if (c.myStatusTheirs == null) {
                            c.myStatusTheirs = Conflict.Status.DELETED;
                        }
                        if (c.myStatusYours == null) {
                            c.myStatusYours = Conflict.Status.DELETED;
                        }
                        this.myConflicts.put(f, c);
                    }
                }
            }
            catch (VcsException ex) {
                throw new IllegalStateException("The git operation should not fail in this context", ex);
            }
        }

        public ColumnInfo[] getMergeInfoColumns() {
            return new ColumnInfo[]{new StatusColumn(false), new StatusColumn(true)};
        }

        public boolean canMerge(VirtualFile file) {
            Conflict c = this.myConflicts.get(file);
            return c != null && c.isMergeable();
        }

        public void conflictResolvedForFile(VirtualFile file, MergeSession.Resolution resolution) {
            Conflict c = this.myConflicts.get(file);
            assert (c != null) : "Conflict was not loaded for the file: " + file.getPath();
            try {
                if (c.isMergeable()) {
                    GitFileUtils.addFiles(GitMergeProvider.this.myProject, c.myRoot, file);
                } else {
                    Conflict.Status status;
                    switch (resolution) {
                        case AcceptedTheirs: {
                            status = c.myStatusTheirs;
                            break;
                        }
                        case AcceptedYours: {
                            status = c.myStatusYours;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported resolution for unmergable files(" + file.getPath() + "): " + resolution);
                        }
                    }
                    switch (status) {
                        case MODIFIED: {
                            GitFileUtils.addFiles(GitMergeProvider.this.myProject, c.myRoot, file);
                            break;
                        }
                        case DELETED: {
                            GitFileUtils.deleteFiles(GitMergeProvider.this.myProject, c.myRoot, file);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported status(" + file.getPath() + "): " + (Object)((Object)status));
                        }
                    }
                }
            }
            catch (VcsException e) {
                log.error("Unexpected exception during the git operation (" + file.getPath() + ")", (Throwable)e);
            }
        }

        class StatusColumn
        extends ColumnInfo<VirtualFile, String> {
            private final boolean myIsTheirs;

            public StatusColumn(boolean isTheirs) {
                super(isTheirs ? GitBundle.message("merge.tool.column.theirs.status", new Object[0]) : GitBundle.message("merge.tool.column.yours.status", new Object[0]));
                this.myIsTheirs = isTheirs;
            }

            public String valueOf(VirtualFile file) {
                Conflict c = MyMergeSession.this.myConflicts.get(file);
                assert (c != null) : "No conflict for the file " + file;
                Conflict.Status s = this.myIsTheirs ? c.myStatusTheirs : c.myStatusYours;
                switch (s) {
                    case MODIFIED: {
                        return GitBundle.message("merge.tool.column.status.modified", new Object[0]);
                    }
                    case DELETED: {
                        return GitBundle.message("merge.tool.column.status.deleted", new Object[0]);
                    }
                }
                throw new IllegalStateException("Unknown status " + (Object)((Object)s) + " for file " + file.getPath());
            }
        }
    }

    private static class Conflict {
        VirtualFile myFile;
        VirtualFile myRoot;
        Status myStatusTheirs;
        Status myStatusYours;

        private Conflict() {
        }

        boolean isMergeable() {
            return this.myStatusTheirs == Status.MODIFIED && this.myStatusYours == Status.MODIFIED;
        }

        static enum Status {
            MODIFIED,
            DELETED;

        }
    }
}

