/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.RemovePropertyLocalFix;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.BidirectionalMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InconsistentResourceBundleInspection
extends DescriptorProviderInspection {
    private JCheckBox myReportMissingTranslationsCheckBox;
    private JCheckBox myReportInconsistentPropertiesCheckBox;
    private JPanel myOptionsPanel;
    private JCheckBox myReportDuplicatedPropertiesCheckBox;
    public boolean REPORT_MISSING_TRANSLATIONS = true;
    public boolean REPORT_INCONSISTENT_PROPERTIES = true;
    public boolean REPORT_DUPLICATED_PROPERTIES = true;

    public InconsistentResourceBundleInspection() {
        this.$$$setupUI$$$();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InconsistentResourceBundleInspection.this.REPORT_INCONSISTENT_PROPERTIES = InconsistentResourceBundleInspection.this.myReportInconsistentPropertiesCheckBox.isSelected();
                InconsistentResourceBundleInspection.this.REPORT_MISSING_TRANSLATIONS = InconsistentResourceBundleInspection.this.myReportMissingTranslationsCheckBox.isSelected();
                InconsistentResourceBundleInspection.this.REPORT_DUPLICATED_PROPERTIES = InconsistentResourceBundleInspection.this.myReportDuplicatedPropertiesCheckBox.isSelected();
            }
        };
        this.myReportInconsistentPropertiesCheckBox.addActionListener(listener);
        this.myReportMissingTranslationsCheckBox.addActionListener(listener);
        this.myReportDuplicatedPropertiesCheckBox.addActionListener(listener);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = PropertiesBundle.message((String)"properties.files.inspection.group.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inconsistent.resource.bundle.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("InconsistentResourceBundle" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection.getShortName must not return null");
        }
        return "InconsistentResourceBundle";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        this.myReportInconsistentPropertiesCheckBox.setSelected(this.REPORT_INCONSISTENT_PROPERTIES);
        this.myReportMissingTranslationsCheckBox.setSelected(this.REPORT_MISSING_TRANSLATIONS);
        this.myReportDuplicatedPropertiesCheckBox.setSelected(this.REPORT_DUPLICATED_PROPERTIES);
        return this.myOptionsPanel;
    }

    public void runInspection(AnalysisScope scope, final InspectionManager manager) {
        THashSet visitedBundles = new THashSet();
        scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Set)visitedBundles){
            final /* synthetic */ Set val$visitedBundles;
            {
                this.val$visitedBundles = set;
            }

            public void visitFile(PsiFile file) {
                InconsistentResourceBundleInspection.this.checkFile(file, manager, this.val$visitedBundles);
            }
        });
    }

    @NotNull
    public JobDescriptor[] getJobDescriptors() {
        if (JobDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection.getJobDescriptors must not return null");
        }
        return JobDescriptor.EMPTY_ARRAY;
    }

    private void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, Set<com.intellij.lang.properties.ResourceBundle> visitedBundles) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/i18n/InconsistentResourceBundleInspection.checkFile must not be null");
        }
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        com.intellij.lang.properties.ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        if (!visitedBundles.add(resourceBundle)) {
            return;
        }
        List files = resourceBundle.getPropertiesFiles(manager.getProject());
        if (files.size() < 2) {
            return;
        }
        BidirectionalMap parents = new BidirectionalMap();
        for (PropertiesFile f : files) {
            PropertiesFile parent = PropertiesUtil.getParent((PropertiesFile)f, (List)files);
            if (parent == null) continue;
            parents.put((Object)f, (Object)parent);
        }
        THashMap keysUpToParent = new THashMap();
        for (PropertiesFile f : files) {
            THashSet keys = new THashSet(f.getNamesMap().keySet());
            PropertiesFile parent = (PropertiesFile)parents.get((Object)f);
            while (parent != null) {
                keys.addAll(parent.getNamesMap().keySet());
                parent = (PropertiesFile)parents.get((Object)parent);
            }
            keysUpToParent.put(f, keys);
        }
        if (this.REPORT_MISSING_TRANSLATIONS) {
            this.checkMissingTranslations((BidirectionalMap<PropertiesFile, PropertiesFile>)parents, files, (Map<PropertiesFile, Set<String>>)keysUpToParent, manager);
        }
        if (this.REPORT_INCONSISTENT_PROPERTIES) {
            this.checkConsistency((BidirectionalMap<PropertiesFile, PropertiesFile>)parents, files, (Map<PropertiesFile, Set<String>>)keysUpToParent, manager);
        }
        if (this.REPORT_DUPLICATED_PROPERTIES) {
            this.checkDuplicatedProperties((BidirectionalMap<PropertiesFile, PropertiesFile>)parents, files, (Map<PropertiesFile, Set<String>>)keysUpToParent, manager);
        }
    }

    private void checkDuplicatedProperties(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, InspectionManager manager) {
        for (PropertiesFile file : files) {
            PropertiesFile parent = (PropertiesFile)parents.get((Object)file);
            if (parent == null) continue;
            Set<String> parentKeys = keysUpToParent.get(parent);
            THashSet overriddenKeys = new THashSet(file.getNamesMap().keySet());
            overriddenKeys.retainAll(parentKeys);
            for (String overriddenKey : overriddenKeys) {
                Property property = file.findPropertyByKey(overriddenKey);
                assert (property != null);
                while (parent != null) {
                    Property parentProperty = parent.findPropertyByKey(overriddenKey);
                    if (parentProperty != null && Comparing.strEqual((String)property.getValue(), (String)parentProperty.getValue())) {
                        String message = InspectionsBundle.message((String)"inconsistent.bundle.property.inherited.with.the.same.value", (Object[])new Object[]{parent.getName()});
                        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)property, message, (LocalQuickFix)RemovePropertyLocalFix.INSTANCE, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
                        this.addProblemElement((RefEntity)this.getRefManager().getReference((PsiElement)file), new CommonProblemDescriptor[]{descriptor});
                    }
                    parent = (PropertiesFile)parents.get((Object)parent);
                }
            }
        }
    }

    private void checkConsistency(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, InspectionManager manager) {
        for (PropertiesFile file : files) {
            PropertiesFile parent = (PropertiesFile)parents.get((Object)file);
            THashSet parentKeys = keysUpToParent.get(parent);
            if (parent == null) {
                parentKeys = new THashSet();
                for (PropertiesFile otherTopLevelFile : files) {
                    if (otherTopLevelFile == file || parents.get((Object)otherTopLevelFile) != null) continue;
                    parent = otherTopLevelFile;
                    parentKeys.addAll(otherTopLevelFile.getNamesMap().keySet());
                }
                if (parent == null) continue;
            }
            THashSet keys = new THashSet(file.getNamesMap().keySet());
            keys.removeAll((Collection<?>)parentKeys);
            for (String inconsistentKey : keys) {
                Property property = file.findPropertyByKey(inconsistentKey);
                assert (property != null);
                String message = InspectionsBundle.message((String)"inconsistent.bundle.property.error", (Object[])new Object[]{inconsistentKey, parent.getName()});
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)property, message, false, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                this.addProblemElement((RefEntity)this.getRefManager().getReference((PsiElement)file), new CommonProblemDescriptor[]{descriptor});
            }
        }
    }

    private void checkMissingTranslations(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, InspectionManager manager) {
        for (PropertiesFile file : files) {
            boolean isLeaf;
            PropertiesFile parent = (PropertiesFile)parents.get((Object)file);
            if (parent == null) continue;
            List children = parents.getKeysByValue((Object)file);
            boolean bl = isLeaf = children == null || children.isEmpty();
            if (!isLeaf) continue;
            THashSet keys = file.getNamesMap().keySet();
            THashSet parentKeys = new THashSet((Collection)keysUpToParent.get(parent));
            if (parent.getLocale().getLanguage().equals(file.getLocale().getLanguage())) {
                keys = new THashSet(keys);
                keys.addAll(parent.getNamesMap().keySet());
                parent = (PropertiesFile)parents.get((Object)parent);
                if (parent == null) continue;
                parentKeys = new THashSet((Collection)keysUpToParent.get(parent));
            }
            parentKeys.removeAll((Collection<?>)keys);
            for (String untranslatedKey : parentKeys) {
                Property untranslatedProperty = null;
                PropertiesFile untranslatedFile = parent;
                while (untranslatedFile != null && (untranslatedProperty = untranslatedFile.findPropertyByKey(untranslatedKey)) == null) {
                    untranslatedFile = (PropertiesFile)parents.get((Object)untranslatedFile);
                }
                assert (untranslatedProperty != null);
                String message = InspectionsBundle.message((String)"inconsistent.bundle.untranslated.property.error", (Object[])new Object[]{untranslatedKey, file.getName()});
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)untranslatedProperty, message, false, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                this.addProblemElement((RefEntity)this.getRefManager().getReference((PsiElement)untranslatedFile), new CommonProblemDescriptor[]{descriptor});
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myReportMissingTranslationsCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inconsistent.bundle.report.missing.translations"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myReportInconsistentPropertiesCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inconsistent.bundle.report.inconsistent.properties"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myReportDuplicatedPropertiesCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inconsistent.bundle.report.duplicate.properties.values"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myOptionsPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

