/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ChangeExtendsImplementsQuickFix
implements IntentionAction {
    @Nullable
    private final GrExtendsClause myExtendsClause;
    @Nullable
    private final GrImplementsClause myImplementsClause;
    final GrTypeDefinition myClass;

    public ChangeExtendsImplementsQuickFix(GrExtendsClause extendsClause, GrImplementsClause implementsClause) {
        this.myExtendsClause = extendsClause;
        this.myImplementsClause = implementsClause;
        if (this.myImplementsClause != null) {
            this.myClass = (GrTypeDefinition)this.myImplementsClause.getParent();
        } else {
            assert (this.myExtendsClause != null);
            this.myClass = (GrTypeDefinition)this.myExtendsClause.getParent();
        }
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("change.implements.and.extends.classes", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix.isAvailable must not be null");
        }
        return this.myClass != null && this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/ChangeExtendsImplementsQuickFix.invoke must not be null");
        }
        GrCodeReferenceElement[] extendsReferenceElements = GrCodeReferenceElement.EMPTY_ARRAY;
        GrCodeReferenceElement[] implementsReferenceElements = GrCodeReferenceElement.EMPTY_ARRAY;
        if (this.myExtendsClause != null) {
            extendsReferenceElements = this.myExtendsClause.getReferenceElements();
        }
        if (this.myImplementsClause != null) {
            implementsReferenceElements = this.myImplementsClause.getReferenceElements();
        }
        TreeSet<String> classes = new TreeSet<String>();
        TreeSet<String> interfaces = new TreeSet<String>();
        for (GrCodeReferenceElement extendsReferenceElement : extendsReferenceElements) {
            PsiElement extendsElement = extendsReferenceElement.resolve();
            if (!(extendsElement instanceof PsiClass) || this.myClass.isInterface() && !((PsiClass)extendsElement).isInterface()) continue;
            if (this.myClass.isInterface()) {
                if (!((PsiClass)extendsElement).isInterface()) continue;
                classes.add(extendsReferenceElement.getCanonicalText());
                continue;
            }
            if (((PsiClass)extendsElement).isInterface()) {
                interfaces.add(extendsReferenceElement.getCanonicalText());
                continue;
            }
            classes.add(extendsReferenceElement.getCanonicalText());
        }
        for (GrCodeReferenceElement implementsReferenceElement : implementsReferenceElements) {
            PsiElement implementsElement = implementsReferenceElement.resolve();
            if (!(implementsElement instanceof PsiClass)) continue;
            if (this.myClass.isInterface()) {
                if (!((PsiClass)implementsElement).isInterface()) continue;
                classes.add(implementsReferenceElement.getCanonicalText());
                continue;
            }
            if (((PsiClass)implementsElement).isInterface()) {
                interfaces.add(implementsReferenceElement.getCanonicalText());
                continue;
            }
            classes.add(implementsReferenceElement.getCanonicalText());
        }
        if (this.myExtendsClause != null) {
            ASTNode extendsClauseNode = this.myExtendsClause.getNode();
            extendsClauseNode.getTreeParent().removeChild(extendsClauseNode);
        }
        if (this.myImplementsClause != null) {
            ASTNode implClauseNode = this.myImplementsClause.getNode();
            implClauseNode.getTreeParent().removeChild(implClauseNode);
        }
        if (!classes.isEmpty()) {
            this.addNewClause(classes, project, true);
        }
        if (!interfaces.isEmpty()) {
            this.addNewClause(interfaces, project, false);
        }
        CodeStyleManager.getInstance((Project)project).reformatText(this.myClass.getContainingFile(), this.myClass.getTextRange().getStartOffset(), this.myClass.getBody().getTextOffset() + 2);
    }

    private void addNewClause(Set<String> elements, Project project, boolean isExtends) throws IncorrectOperationException {
        GrReferenceList clause;
        String classText = "class A " + (isExtends ? "extends " : "implements ");
        boolean first = true;
        for (String str : elements) {
            if (!first) {
                classText = classText + ", ";
            }
            classText = classText + str;
            first = false;
        }
        classText = classText + " {}";
        GrTypeDefinition definition = GroovyPsiElementFactory.getInstance(project).createTypeDefinition(classText);
        GrReferenceList grReferenceList = clause = isExtends ? definition.getExtendsClause() : definition.getImplementsClause();
        assert (clause != null);
        this.myClass.getNode().addChild(clause.getNode(), this.myClass.getBody().getNode());
        PsiUtil.shortenReferences(clause);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

