/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.secondUnsafeCall;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.inspections.SecondUnsafeCallQuickFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class SecondUnsafeCallInspection
extends GroovySuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection.buildVisitor must not be null");
        }
        GroovyPsiElementVisitor groovyPsiElementVisitor = new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            @Override
            public void visitReferenceExpression(GrReferenceExpression refExpression) {
                SecondUnsafeCallInspection.this.checkForSecondUnsafeCall(refExpression, holder);
            }
        });
        if (groovyPsiElementVisitor == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection.buildVisitor must not return null");
        }
        return groovyPsiElementVisitor;
    }

    private void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder) {
        this.checkForSecondUnsafeCall(expression, holder, null);
    }

    private void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder, PsiElement hightlightElement) {
        GrReferenceExpression referenceExpression;
        if (hightlightElement == null) {
            hightlightElement = expression;
        }
        if (GroovyElementTypes.mDOT.equals((referenceExpression = (GrReferenceExpression)expression).getDotTokenType())) {
            GrExpression qualifierExpression = referenceExpression.getQualifierExpression();
            if (qualifierExpression instanceof GrMethodCallExpression) {
                GrExpression expression1 = ((GrMethodCallExpression)qualifierExpression).getInvokedExpression();
                if (!(expression1 instanceof GrReferenceExpression)) {
                    return;
                }
                if (GroovyElementTypes.mOPTIONAL_DOT.equals(((GrReferenceExpression)expression1).getDotTokenType())) {
                    holder.registerProblem(hightlightElement, GroovyInspectionBundle.message("call.can.throw.npe", new Object[0]), new LocalQuickFix[]{new SecondUnsafeCallQuickFix()});
                }
            } else if (qualifierExpression instanceof GrReferenceExpression && GroovyElementTypes.mOPTIONAL_DOT.equals(((GrReferenceExpression)qualifierExpression).getDotTokenType())) {
                holder.registerProblem(hightlightElement, GroovyInspectionBundle.message("call.can.throw.npe", new Object[0]), new LocalQuickFix[]{new SecondUnsafeCallQuickFix()});
            }
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection.getGroupDisplayName must not return null");
        }
        return "Probable bugs";
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"Groovy", this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection.getGroupPath must not return null");
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("second.unsafe.call", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SecondUnsafeCall" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/secondUnsafeCall/SecondUnsafeCallInspection.getShortName must not return null");
        }
        return "SecondUnsafeCall";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private IElementType getDotType(PsiElement element) {
        GrExpression invokedExpr;
        if (element instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)element).getDotTokenType();
        }
        if (element instanceof GrMethodCallExpression && (invokedExpr = ((GrMethodCallExpression)element).getInvokedExpression()) instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)element).getDotTokenType();
        }
        return null;
    }
}

