/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.config.GroovyModuleConverter;

public class GroovyProjectConverter
extends ProjectConverter {
    @NonNls
    private static final String GRAILS_TESTS_RUN_CONFIGURATION_TYPE = "GrailsTestsRunConfigurationType";
    @NonNls
    private static final String GANT_SCRIPT_RUN_CONFIGURATION = "GantScriptRunConfiguration";
    @NonNls
    private static final String GRAILS_RUN_CONFIGURATION_TYPE = "GrailsRunConfigurationType";

    public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
        return new GroovyModuleConverter();
    }

    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        return new ConversionProcessor<RunManagerSettings>(){

            public boolean isConversionNeeded(RunManagerSettings settings) {
                for (Element element : settings.getRunConfigurations()) {
                    String confType = element.getAttributeValue("type");
                    if (GroovyProjectConverter.GRAILS_TESTS_RUN_CONFIGURATION_TYPE.equals(confType) || GroovyProjectConverter.GANT_SCRIPT_RUN_CONFIGURATION.equals(confType)) {
                        return true;
                    }
                    if (!GroovyProjectConverter.GRAILS_RUN_CONFIGURATION_TYPE.equals(confType) || !"Grails Application".equals(element.getAttributeValue("factoryName"))) continue;
                    return true;
                }
                return false;
            }

            public void process(RunManagerSettings settings) throws CannotConvertException {
                for (Element element : settings.getRunConfigurations()) {
                    String confType = element.getAttributeValue("type");
                    boolean wasGrails = GroovyProjectConverter.GRAILS_TESTS_RUN_CONFIGURATION_TYPE.equals(confType);
                    if (wasGrails || GroovyProjectConverter.GANT_SCRIPT_RUN_CONFIGURATION.equals(confType)) {
                        if ("true".equals(element.getAttributeValue("default"))) {
                            element.detach();
                            continue;
                        }
                        element.setAttribute("type", wasGrails ? GroovyProjectConverter.GRAILS_RUN_CONFIGURATION_TYPE : "GroovyScriptRunConfiguration");
                        element.setAttribute("factoryName", wasGrails ? "Grails" : "Groovy Script");
                        continue;
                    }
                    if (!GroovyProjectConverter.GRAILS_RUN_CONFIGURATION_TYPE.equals(confType) || !"Grails Application".equals(element.getAttributeValue("factoryName"))) continue;
                    element.setAttribute("factoryName", "Grails");
                }
            }
        };
    }
}

