/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSuperReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.ClosureSyntheticParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyCodeFragmentFactory
implements CodeFragmentFactory {
    private static final String EVAL_NAME = "_JETGROOVY_EVAL_";
    private static final String IMPORTS = "___$$IMPORTS$$___";
    private static final String TEXT = "___$$TEXT$$___";

    private static String unwrapVals(List<String> vals) {
        return "java.lang.Object[] |vals = new java.lang.Object[]{" + StringUtil.join(vals, (String)",") + "};\n" + "java.lang.Object[] |resVals = new java.lang.Object[" + vals.size() + "];\n" + "for (int |iii =0; |iii<|vals.length; |iii++){java.lang.Object |o = |vals[|iii];\n" + "if (|o instanceof groovy.lang.Reference) {|o = ((groovy.lang.Reference)|o).get();}\n" + "|resVals[|iii] = |o;" + "}\n";
    }

    public JavaCodeFragment createCodeFragment(TextWithImports textWithImports, PsiElement context, Project project) {
        String text = textWithImports.getText();
        String imports = textWithImports.getImports();
        Pair<Map<String, String>, GroovyFile> pair = GroovyCodeFragmentFactory.externalParameters(text, context);
        GroovyFile toEval = (GroovyFile)pair.second;
        final Map parameters = (Map)pair.first;
        ArrayList names = new ArrayList(parameters.keySet());
        List values = ContainerUtil.map(names, (Function)new Function<String, String>(){

            public String fun(String name) {
                return (String)parameters.get(name);
            }
        });
        text = toEval.getText();
        String groovyText = StringUtil.join(names, (String)", ") + "->" + GroovyCodeFragmentFactory.stripImports(text, toEval);
        PsiClass contextClass = PsiUtil.getContextClass(context);
        boolean isStatic = GroovyCodeFragmentFactory.isStaticContext(context);
        StringBuffer javaText = new StringBuffer();
        javaText.append("groovy.lang.MetaClass |mc;\n");
        javaText.append("java.lang.Class |clazz;\n");
        if (!isStatic) {
            javaText.append("|clazz = ((java.lang.Object)this).getClass();\n");
            javaText.append("|mc = ((groovy.lang.GroovyObject)this).getMetaClass();\n");
        } else {
            assert (contextClass != null);
            javaText.append("|clazz = java.lang.Class.forName(\"").append(contextClass.getQualifiedName()).append("\");\n");
            javaText.append("|mc = groovy.lang.GroovySystem.getMetaClassRegistry().getMetaClass(|clazz);\n");
        }
        javaText.append("final java.lang.ClassLoader |parentLoader = |clazz.getClassLoader();\n   final groovy.lang.GroovyClassLoader |loader = new groovy.lang.GroovyClassLoader(|parentLoader);\n   final java.lang.Class |c = |loader.parseClass(");
        javaText.append("\"___$$IMPORTS$$___class DUMMY { public groovy.lang.Closure _JETGROOVY_EVAL_ = {___$$TEXT$$___}}\"");
        javaText.append(", \"DUMMY.groovy\");\n   int |i;\n   java.lang.reflect.Field[] |fields = |c.getFields();\n   for (int |j = 0; |j < |fields.length; |j++) if (|fields[|j].getName().equals(\"_JETGROOVY_EVAL_\")) {|i = |j; break;}\n   final java.lang.reflect.Field |field = |fields[|i];\n   final java.lang.Object |closure = |field.get(|c.newInstance());\n");
        javaText.append("groovy.lang.ExpandoMetaClass |emc = new groovy.lang.ExpandoMetaClass(|clazz);\n");
        if (!isStatic) {
            javaText.append("|emc.setProperty(\"").append(EVAL_NAME).append("\", |closure);\n");
            javaText.append("((groovy.lang.GroovyObject)this).setMetaClass(|emc);\n");
        } else {
            javaText.append("((groovy.lang.GroovyObject)|emc.getProperty(\"static\")).setProperty(\"").append(EVAL_NAME).append("\", |closure);\n");
            javaText.append("groovy.lang.GroovySystem.getMetaClassRegistry().setMetaClass(|clazz, |emc);\n");
        }
        javaText.append("|emc.initialize();\n");
        javaText.append(GroovyCodeFragmentFactory.unwrapVals(values));
        if (!isStatic) {
            javaText.append("java.lang.Object |res = ((groovy.lang.MetaClassImpl)|emc).invokeMethod(this, \"").append(EVAL_NAME).append("\", |resVals);\n");
            javaText.append("((groovy.lang.GroovyObject)this).setMetaClass(|mc);");
        } else {
            javaText.append("java.lang.Object |res = ((groovy.lang.MetaClassImpl)|emc).invokeStaticMethod(|clazz, \"").append(EVAL_NAME).append("\", |resVals);\n");
            javaText.append("groovy.lang.GroovySystem.getMetaClassRegistry().setMetaClass(|clazz, |mc);\n");
        }
        javaText.append("|res");
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)toEval.getProject()).getElementFactory();
        String hiddenJavaVars = StringUtil.replace((String)javaText.toString(), (String)"|", (String)("_$$_$$$_$$$$$$$$$_" + new Random().nextInt(42)));
        String finalText = StringUtil.replace((String)StringUtil.replace((String)hiddenJavaVars, (String)TEXT, (String)groovyText), (String)IMPORTS, (String)imports);
        JavaCodeFragment result = factory.createCodeBlockCodeFragment(finalText, null, true);
        if (contextClass != null) {
            result.setThisType((PsiType)factory.createType(contextClass));
        }
        return result;
    }

    public static Pair<Map<String, String>, GroovyFile> externalParameters(String text, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/debugger/GroovyCodeFragmentFactory.externalParameters must not be null");
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(context.getProject());
        final GroovyFile toEval = factory.createGroovyFile(text, false, context);
        final GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)context, GrClosableBlock.class);
        THashMap parameters = new THashMap();
        toEval.accept(new GroovyRecursiveElementVisitor((Map)parameters, factory){
            final /* synthetic */ Map val$parameters;
            final /* synthetic */ GroovyPsiElementFactory val$factory;
            {
                this.val$parameters = map;
                this.val$factory = groovyPsiElementFactory;
            }

            @Override
            public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
                String qName;
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiMethod && "getDelegate".equals(((PsiMethod)resolved).getName()) && closure != null) {
                    this.replaceWithReference(referenceExpression, "owner");
                    return;
                }
                if (resolved instanceof GrField && !referenceExpression.isQualified()) {
                    this.replaceWithReference(referenceExpression, (closure == null ? "delegate" : "owner") + "." + referenceExpression.getReferenceName());
                    return;
                }
                if (resolved instanceof GrVariableBase && !(resolved instanceof GrField) && !PsiTreeUtil.isAncestor((PsiElement)toEval, (PsiElement)resolved, (boolean)false)) {
                    String name = ((GrVariableBase)resolved).getName();
                    if (resolved instanceof ClosureSyntheticParameter && PsiTreeUtil.isAncestor((PsiElement)toEval, (PsiElement)((ClosureSyntheticParameter)resolved).getClosure(), (boolean)false)) {
                        return;
                    }
                    String value = closure != null && PsiTreeUtil.findCommonParent((PsiElement)resolved, (PsiElement)closure) != closure && !(resolved instanceof ClosureSyntheticParameter) ? "this." + name : name;
                    this.val$parameters.put(name, value);
                }
                if (resolved instanceof PsiClass && (qName = ((PsiClass)resolved).getQualifiedName()) != null && qName.contains(".") && !referenceExpression.isQualified()) {
                    this.replaceWithReference(referenceExpression, qName);
                }
            }

            @Override
            public void visitThisExpression(GrThisReferenceExpression thisExpression) {
                super.visitThisExpression(thisExpression);
                this.replaceWithReference(thisExpression, closure == null ? "delegate" : "owner");
            }

            @Override
            public void visitSuperExpression(GrSuperReferenceExpression superExpression) {
                super.visitSuperExpression(superExpression);
                this.replaceWithReference(superExpression, closure == null ? "delegate" : "owner");
            }

            private void replaceWithReference(GrExpression expr, String exprText) {
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expr.getProject());
                this.visitReferenceExpression((GrReferenceExpression)expr.replaceWithExpression(factory.createExpressionFromText(exprText), false));
            }

            @Override
            public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
                if (refElement.getQualifier() != null) {
                    super.visitCodeReferenceElement(refElement);
                } else {
                    String qName;
                    PsiElement resolved = refElement.resolve();
                    if (resolved instanceof PsiClass && (qName = ((PsiClass)resolved).getQualifiedName()) != null) {
                        int dotIndex = qName.lastIndexOf(".");
                        if (dotIndex < 0) {
                            return;
                        }
                        String packageName = qName.substring(0, dotIndex);
                        refElement.setQualifier(this.val$factory.createReferenceElementFromText(packageName));
                    }
                }
            }
        });
        return Pair.create((Object)parameters, (Object)toEval);
    }

    private static String stripImports(String text, GroovyFile toEval) {
        GrImportStatement[] imports = toEval.getImportStatements();
        for (int i = imports.length - 1; i >= 0; --i) {
            TextRange range = imports[i].getTextRange();
            text = text.substring(0, range.getStartOffset()) + text.substring(range.getEndOffset(), text.length());
        }
        return StringUtil.escapeStringCharacters((String)text);
    }

    public JavaCodeFragment createPresentationCodeFragment(TextWithImports item, PsiElement context, Project project) {
        GroovyCodeFragment result = new GroovyCodeFragment(project, item.getText());
        result.setContext(context);
        return result;
    }

    private static boolean isStaticContext(PsiElement context) {
        for (PsiElement parent = context; parent != null; parent = parent.getParent()) {
            if (parent instanceof PsiModifierListOwner && ((PsiModifierListOwner)parent).hasModifierProperty("static")) {
                return true;
            }
            if (!(parent instanceof GrTypeDefinition) && !(parent instanceof GroovyFile)) continue;
            return false;
        }
        return false;
    }

    public boolean isContextAccepted(PsiElement context) {
        return context != null && context.getLanguage().equals(GroovyFileType.GROOVY_FILE_TYPE.getLanguage());
    }

    public String getDisplayName() {
        return "Groovy";
    }

    public LanguageFileType getFileType() {
        return GroovyFileType.GROOVY_FILE_TYPE;
    }
}

