/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GDKSuperMethodSearcher
implements QueryExecutor<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    public boolean execute(SuperMethodsSearch.SearchParameters queryParameters, Processor<MethodSignatureBackedByPsiMethod> consumer) {
        PsiMethod method = queryParameters.getMethod();
        if (!(method instanceof GrMethod)) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return true;
        }
        HierarchicalMethodSignature hierarchicalSignature = method.getHierarchicalMethodSignature();
        if (hierarchicalSignature.getSuperSignatures().size() != 0) {
            return true;
        }
        Project project = method.getProject();
        GroovyPsiManager grPsiManager = GroovyPsiManager.getInstance(project);
        List<PsiMethod> allMethods = grPsiManager.getDefaultMethods(psiClass);
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        ArrayList<PsiMethod> goodSupers = new ArrayList<PsiMethod>();
        for (PsiMethod m : allMethods) {
            if (!PsiImplUtil.isExtendsSignature((MethodSignature)m.getHierarchicalMethodSignature(), (MethodSignature)signature)) continue;
            goodSupers.add(m);
        }
        if (goodSupers.size() == 0) {
            return true;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        final GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        ArrayList result = new ArrayList(goodSupers.size());
        result.add(goodSupers.get(0));
        Comparator<PsiMethod> comparator = new Comparator<PsiMethod>(){

            @Override
            public int compare(PsiMethod o1, PsiMethod o2) {
                PsiType type2;
                GrGdkMethod m1 = (GrGdkMethod)o1;
                GrGdkMethod m2 = (GrGdkMethod)o2;
                PsiType type1 = TypeConversionUtil.erasure((PsiType)m1.getStaticMethod().getParameterList().getParameters()[0].getType());
                if (TypesUtil.isAssignable(type1, type2 = TypeConversionUtil.erasure((PsiType)m2.getStaticMethod().getParameterList().getParameters()[0].getType()), psiManager, searchScope)) {
                    return -1;
                }
                if (TypesUtil.isAssignable(type2, type1, psiManager, searchScope)) {
                    return 1;
                }
                return 0;
            }
        };
        block1: for (PsiMethod current : goodSupers) {
            Iterator i = result.iterator();
            while (i.hasNext()) {
                PsiMethod m = (PsiMethod)i.next();
                int res = comparator.compare(m, current);
                if (res > 0) continue block1;
                if (res >= 0) continue;
                i.remove();
            }
            result.add(current);
        }
        for (PsiMethod psiMethod : result) {
            if (consumer.process((Object)((GrGdkMethod)psiMethod).getStaticMethod().getHierarchicalMethodSignature())) continue;
            return false;
        }
        return true;
    }
}

