/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gradle.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gradle.openapi.external.ui.SettingsNodeVersion1;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.gradle.GradleLibraryManager;
import org.jetbrains.plugins.groovy.gradle.ui.GradlePanelWrapper;
import org.jetbrains.plugins.groovy.gradle.ui.GradleUISettings;

public class ShowGradleUIAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        new GradleUiDialog((Project)e.getData(DataKeys.PROJECT), (Module)e.getData(DataKeys.MODULE)).show();
    }

    public void update(AnActionEvent e) {
        boolean enabled = ShowGradleUIAction.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    private static boolean isEnabled(AnActionEvent e) {
        if (!"true".equals(System.getProperty("gradle.ui.action"))) {
            return false;
        }
        Project project = (Project)e.getData(DataKeys.PROJECT);
        return project != null && GradleLibraryManager.getSdkHome((Module)e.getData(DataKeys.MODULE), project) != null;
    }

    private static class GradleUiDialog
    extends DialogWrapper {
        private static final String MAIN_COMPONENT_AS_DIALOG = "main-component-as-dialog";
        private static final String LOCATION_Y = "location-y";
        private static final String LOCATION_X = "location-x";
        private static final String HEIGHT = "height";
        private static final String WIDTH = "width";
        private final GradlePanelWrapper myGradlePanelWrapper;
        private Boolean canClose;
        private final Project myProject;

        public GradleUiDialog(final Project project, @Nullable Module module) {
            super(project);
            this.myProject = project;
            this.myGradlePanelWrapper = new GradlePanelWrapper();
            this.myGradlePanelWrapper.initalize(module, project);
            Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

                public void dispose() {
                    GradleUiDialog.this.saveSettings(project);
                    GradleUiDialog.this.myGradlePanelWrapper.close();
                }
            });
            this.setModal(false);
            this.setSize(400, 700);
            this.setTitle("Gradle");
            ProjectManager.getInstance().addProjectManagerListener(project, (ProjectManagerListener)new ProjectManagerAdapter(){

                public boolean canCloseProject(Project project) {
                    if (GradleUiDialog.this.canClose == null) {
                        GradleUiDialog.this.canClose = GradleUiDialog.this.myGradlePanelWrapper.canClose();
                    }
                    return GradleUiDialog.this.canClose;
                }
            });
            this.init();
        }

        public void show() {
            super.show();
            this.restoreSettings(this.myProject);
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(this.myGradlePanelWrapper.getComponent());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            return panel;
        }

        private void restoreSettings(Project project) {
            GradleUISettings gradleUISettings = GradleUISettings.getInstance(project);
            SettingsNodeVersion1 settingsNode = gradleUISettings.getRootNode().getChildNode(MAIN_COMPONENT_AS_DIALOG);
            if (settingsNode != null) {
                int x = settingsNode.getValueOfChildAsInt(LOCATION_X, this.getLocation().x);
                int y = settingsNode.getValueOfChildAsInt(LOCATION_Y, this.getLocation().y);
                int width = settingsNode.getValueOfChildAsInt(WIDTH, this.getSize().width);
                int height = settingsNode.getValueOfChildAsInt(HEIGHT, this.getSize().height);
                this.setLocation(x, y);
                this.setSize(width, height);
            }
        }

        private void saveSettings(Project project) {
            GradleUISettings gradleUISettings = GradleUISettings.getInstance(project);
            SettingsNodeVersion1 settingsNode = gradleUISettings.getRootNode().addChildIfNotPresent(MAIN_COMPONENT_AS_DIALOG);
            settingsNode.setValueOfChildAsInt(LOCATION_X, this.getLocation().x);
            settingsNode.setValueOfChildAsInt(LOCATION_Y, this.getLocation().y);
            settingsNode.setValueOfChildAsInt(WIDTH, this.getSize().width);
            settingsNode.setValueOfChildAsInt(HEIGHT, this.getSize().height);
        }
    }
}

