/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.MergeIfAndPredicate;
import org.jetbrains.plugins.groovy.intentions.utils.ConditionalUtils;
import org.jetbrains.plugins.groovy.intentions.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class MergeIfAndIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        MergeIfAndPredicate mergeIfAndPredicate = new MergeIfAndPredicate();
        if (mergeIfAndPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/control/MergeIfAndIntention.getElementPredicate must not return null");
        }
        return mergeIfAndPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/control/MergeIfAndIntention.processIntention must not be null");
        }
        GrIfStatement parentStatement = (GrIfStatement)element;
        assert (parentStatement != null);
        GrStatement parentThenBranch = parentStatement.getThenBranch();
        GrIfStatement childStatement = (GrIfStatement)ConditionalUtils.stripBraces(parentThenBranch);
        GrExpression childCondition = (GrExpression)childStatement.getCondition();
        String childConditionText = ParenthesesUtils.getPrecendence(childCondition) > 14 ? '(' + childCondition.getText() + ')' : childCondition.getText();
        GrExpression parentCondition = (GrExpression)parentStatement.getCondition();
        String parentConditionText = ParenthesesUtils.getPrecendence(parentCondition) > 14 ? '(' + parentCondition.getText() + ')' : parentCondition.getText();
        GrStatement childThenBranch = childStatement.getThenBranch();
        String statement = "if(" + parentConditionText + "&&" + childConditionText + ')' + childThenBranch.getText();
        IntentionUtils.replaceStatement(statement, parentStatement);
    }
}

