/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiElementUtil;

public class JavaStylePropertiesInvocationIntention
extends Intention {
    @Override
    protected boolean isStopElement(PsiElement element) {
        return super.isStopElement(element) || element instanceof GrClosableBlock;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        GrExpression invoked;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/style/JavaStylePropertiesInvocationIntention.processIntention must not be null");
        }
        assert (element instanceof GrMethodCallExpression || element instanceof GrApplicationStatement);
        GrCall call = (GrCall)element;
        GrExpression grExpression = invoked = call instanceof GrMethodCallExpression ? ((GrMethodCallExpression)call).getInvokedExpression() : ((GrApplicationStatement)call).getFunExpression();
        if (PsiElementUtil.isGetterInvocation(call) && invoked instanceof GrReferenceExpression) {
            String name = ((GrReferenceExpression)invoked).getName();
            assert (name != null);
            name = StringUtil.trimStart((String)name, (String)"get");
            name = StringUtil.decapitalize((String)name);
            JavaStylePropertiesInvocationIntention.replaceWithGetter((GrMethodCallExpression)call, name);
        } else if (PsiElementUtil.isSetterInvocation(call) && invoked instanceof GrReferenceExpression) {
            GrExpression value;
            String name = ((GrReferenceExpression)invoked).getName();
            assert (name != null);
            name = StringUtil.trimStart((String)name, (String)"set");
            name = StringUtil.decapitalize((String)name);
            if (call instanceof GrMethodCallExpression) {
                GrArgumentList args = call.getArgumentList();
                assert (args != null);
                value = args.getExpressionArguments()[0];
            } else {
                GrArgumentList args = call.getArgumentList();
                assert (args != null);
                value = args.getExpressionArguments()[0];
            }
            JavaStylePropertiesInvocationIntention.replaceWithSetter(call, name, value);
        }
    }

    private static void replaceWithSetter(GrCall call, String name, GrExpression value) throws IncorrectOperationException {
        GrReferenceExpression refExpr = (GrReferenceExpression)(call instanceof GrMethodCallExpression ? ((GrMethodCallExpression)call).getInvokedExpression() : ((GrApplicationStatement)call).getFunExpression());
        String oldNameStr = refExpr.getReferenceNameElement().getText();
        String newRefExpr = StringUtil.trimEnd((String)refExpr.getText(), (String)oldNameStr) + name;
        IntentionUtils.replaceStatement(newRefExpr + " = " + value.getText(), (GrStatement)((Object)call));
    }

    private static void replaceWithGetter(GrMethodCallExpression call, String name) throws IncorrectOperationException {
        GrReferenceExpression refExpr = (GrReferenceExpression)call.getInvokedExpression();
        String oldNameStr = refExpr.getReferenceNameElement().getText();
        String newRefExpr = StringUtil.trimEnd((String)refExpr.getText(), (String)oldNameStr) + name;
        IntentionUtils.replaceExpression(newRefExpr, call);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        JavaPropertyInvocationPredicate javaPropertyInvocationPredicate = new JavaPropertyInvocationPredicate();
        if (javaPropertyInvocationPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/style/JavaStylePropertiesInvocationIntention.getElementPredicate must not return null");
        }
        return javaPropertyInvocationPredicate;
    }

    private static class JavaPropertyInvocationPredicate
    implements PsiElementPredicate {
        private JavaPropertyInvocationPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            if (!(element instanceof GrCall)) {
                return false;
            }
            GrCall call = (GrCall)element;
            return PsiElementUtil.isPropertyAccessor(call);
        }
    }
}

