/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class BuiltInTypeFilter
implements ElementFilter {
    public boolean isAcceptable(Object element, PsiElement context) {
        PsiElement previous = PsiImplUtil.realPrevious(context.getParent().getPrevSibling());
        if (previous != null && GroovyTokenTypes.mAT.equals(previous.getNode().getElementType())) {
            return false;
        }
        if (GroovyCompletionUtil.asSimpleVariable(context) || GroovyCompletionUtil.asTypedMethod(context) || GroovyCompletionUtil.asVariableInBlock(context)) {
            return true;
        }
        if (context.getParent() instanceof GrParameter && ((GrParameter)context.getParent()).getTypeElementGroovy() == null || context.getParent() instanceof GrReferenceElement && !(context.getParent().getParent() instanceof GrImportStatement) && !(context.getParent().getParent() instanceof GrPackageDefinition) && !(context.getParent().getParent() instanceof GrArgumentList)) {
            PsiElement prevSibling = context.getPrevSibling();
            if (context.getParent() instanceof GrReferenceElement && prevSibling != null && prevSibling.getNode() != null) {
                ASTNode node = prevSibling.getNode();
                return !GroovyTokenTypes.DOTS.contains(node.getElementType());
            }
            return true;
        }
        if (PsiImplUtil.realPrevious(context.getParent().getPrevSibling()) instanceof GrModifierList) {
            return true;
        }
        if (PsiImplUtil.realPrevious(context.getPrevSibling()) instanceof GrModifierList) {
            return true;
        }
        return context.getParent() instanceof GrExpression && context.getParent().getParent() instanceof GroovyFile && GroovyCompletionUtil.isNewStatement(context, false);
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "built-in-types keywords filter";
    }
}

