/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocFieldReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocMemberReferenceImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;

public class GrDocFieldReferenceImpl
extends GrDocMemberReferenceImpl
implements GrDocFieldReference {
    public GrDocFieldReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocFieldReferenceImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "GrDocFieldReference";
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitDocFieldReference(this);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMethod) {
            String newPropertyName;
            PsiMethod method = (PsiMethod)resolved;
            String oldName = this.getReferenceName();
            if (!method.getName().equals(oldName) && PropertyUtil.isSimplePropertyAccessor((PsiMethod)method) && (newPropertyName = PropertyUtil.getPropertyName((String)newElementName)) != null) {
                return super.handleElementRename(newPropertyName);
            }
        } else if (resolved instanceof GrField && ((GrField)resolved).isProperty()) {
            GrField field = (GrField)resolved;
            String oldName = this.getReferenceName();
            if (oldName != null && oldName.equals(field.getName())) {
                if (oldName.startsWith("get")) {
                    return super.handleElementRename("get" + StringUtil.capitalize((String)newElementName));
                }
                if (oldName.startsWith("set")) {
                    return super.handleElementRename("set" + StringUtil.capitalize((String)newElementName));
                }
            }
        }
        return super.handleElementRename(newElementName);
    }

    @Override
    protected ResolveResult[] multiResolveImpl() {
        GrCodeReferenceElement referenceElement;
        String name = this.getReferenceName();
        GrDocReferenceElement holder = this.getReferenceHolder();
        Object resolved = holder != null ? ((referenceElement = holder.getReferenceElement()) != null ? referenceElement.resolve() : null) : GrDocFieldReferenceImpl.getEnclosingClass(this);
        if (resolved instanceof PsiClass) {
            PropertyResolverProcessor processor = new PropertyResolverProcessor(name, this);
            resolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            ResolveResult[] candidates = processor.getCandidates();
            if (candidates.length == 0) {
                PsiClassType thisType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(resolved, PsiSubstitutor.EMPTY);
                MethodResolverProcessor methodProcessor = new MethodResolverProcessor(name, this, false, (PsiType)thisType, null, PsiType.EMPTY_ARRAY);
                MethodResolverProcessor constructorProcessor = new MethodResolverProcessor(name, this, true, (PsiType)thisType, null, PsiType.EMPTY_ARRAY);
                resolved.processDeclarations((PsiScopeProcessor)methodProcessor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
                resolved.processDeclarations((PsiScopeProcessor)constructorProcessor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
                candidates = (GroovyResolveResult[])ArrayUtil.mergeArrays((Object[])methodProcessor.getCandidates(), (Object[])constructorProcessor.getCandidates(), GroovyResolveResult.class);
                if (candidates.length > 0) {
                    candidates = new GroovyResolveResult[]{candidates[0]};
                }
            }
            return candidates;
        }
        return new ResolveResult[0];
    }
}

