/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.constructor;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.Separators;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ConstructorBody
implements GroovyElementTypes {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker cbMarker = builder.mark();
        if (!ParserUtils.getToken(builder, mLCURLY)) {
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
            cbMarker.rollbackTo();
            return false;
        }
        ParserUtils.getToken(builder, mNLS);
        PsiBuilder.Marker constructorInvokationMarker = builder.mark();
        if (ConstructorBody.parseExplicitConstructor(builder, parser)) {
            constructorInvokationMarker.done((IElementType)EXPLICIT_CONSTRUCTOR);
        } else {
            constructorInvokationMarker.rollbackTo();
        }
        Separators.parse(builder);
        parser.parseBlockBody(builder);
        if (builder.getTokenType() != mRCURLY) {
            builder.error(GroovyBundle.message("rcurly.expected", new Object[0]));
        } else {
            builder.advanceLexer();
        }
        cbMarker.done((IElementType)OPEN_BLOCK);
        return true;
    }

    private static boolean parseExplicitConstructor(PsiBuilder builder, GroovyParser parser) {
        TypeArguments.parse(builder);
        if ((ParserUtils.getToken(builder, kTHIS) || ParserUtils.getToken(builder, kSUPER)) && ParserUtils.lookAhead(builder, mLPAREN)) {
            PsiBuilder.Marker marker = builder.mark();
            ParserUtils.getToken(builder, mLPAREN);
            ArgumentList.parseArgumentList(builder, mRPAREN, parser);
            ParserUtils.getToken(builder, mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]));
            marker.done((IElementType)ARGUMENTS);
            return true;
        }
        return false;
    }
}

