/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class GroovyPsiManager {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager");
    private final Project myProject;
    private Map<String, List<PsiMethod>> myDefaultMethods;
    private static final String DEFAULT_METHODS_QNAME = "org.codehaus.groovy.runtime.DefaultGroovyMethods";
    private static final String DEFAULT_STATIC_METHODS_QNAME = "org.codehaus.groovy.runtime.DefaultGroovyStaticMethods";
    private static final String SWING_BUILDER_QNAME = "groovy.swing.SwingBuilder";
    private GrTypeDefinition myArrayClass;
    private final ConcurrentWeakHashMap<GroovyPsiElement, PsiType> myCalculatedTypes = new ConcurrentWeakHashMap();
    private volatile boolean myRebuildGdkPending = true;
    private final GroovyShortNamesCache myCache;
    private final TypeInferenceHelper myTypeInferenceHelper;
    private static final String SYNTHETIC_CLASS_TEXT = "class __ARRAY__ { public int length }";
    private static final String[] SWING_WIDGETS_METHODS = new String[]{"action", "groovy.swing.impl.DefaultAction", "actions", "java.util.List", "map", "java.util.Map", "buttonGroup", "javax.swing.ButtonGroup", "bind", "org.codehaus.groovy.binding.BindingUpdatable", "model", "org.codehaus.groovy.binding.ModelBinding", "widget", "java.awt.Component", "container", "java.awt.Container", "bean", "java.lang.Object", "dialog", "javax.swing.JDialog", "fileChooser", "javax.swing.JFileChooser", "frame", "javax.swing.JFrame", "optionPane", "javax.swing.JOptionPane", "window", "javax.swing.JWindow", "button", "javax.swing.JButton", "checkBox", "javax.swing.JCheckBox", "checkBoxMenuItem", "javax.swing.JCheckBoxMenuItem", "menuItem", "javax.swing.JMenuItem", "radioButton", "javax.swing.JRadioButton", "radioButtonMenuItem", "javax.swing.JRadioButtonMenuItem", "toggleButton", "javax.swing.JToggleButton", "editorPane", "javax.swing.JEditorPane", "label", "javax.swing.JLabel", "passwordField", "javax.swing.JPasswordField", "textArea", "javax.swing.JTextArea", "textField", "javax.swing.JTextField", "textPane", "javax.swing.JTextPane", "colorChooser", "javax.swing.JColorChooser", "comboBox", "javax.swing.JComboBox", "desktopPane", "javax.swing.JDesktopPane", "formattedTextField", "javax.swing.JFormattedTextField", "internalFrame", "javax.swing.JInternalFrame", "layeredPane", "javax.swing.JLayeredPane", "list", "javax.swing.JList", "menu", "javax.swing.JMenu", "menuBar", "javax.swing.JMenuBar", "panel", "javax.swing.JPanel", "popupMenum", "javax.swing.JPopupMenu", "progressBar", "javax.swing.JProgressBar", "scrollBar", "javax.swing.JScrollBar", "scrollPane", "javax.swing.JScrollPane", "separator", "javax.swing.JSeparator", "slider", "javax.swing.JSlider", "spinner", "javax.swing.JSpinner", "splitPane", "javax.swing.JSplitPane", "tabbedPane", "javax.swing.JTabbedPane", "table", "javax.swing.JTable", "tableColumn", "javax.swing.table.TableColumn", "toolbar", "javax.swing.JToolbar", "tree", "javax.swing.JTree", "viewport", "javax.swing.JViewport", "boundedRangeModel", "javax.swing.DefaultBoundedRangeModel", "spinnerDateModel", "javax.swing.SpinnerDateModel", "spinnerListModel", "javax.swing.SpinnerListModel", "spinnerNumberModel", "javax.swing.SpinnerNumberModel", "tableModel", "javax.swing.table.TableModel", "propertyColumn", "javax.swing.table.TableColumn", "closureColumn", "javax.swing.table.TableColumn", "borderLayout", "java.awt.BorderLayout", "cardLayout", "java.awt.CardLayout", "flowLayout", "java.awt.FlowLayout", "gridBagLayout", "java.awt.GridBagLayout", "gridLayout", "java.awt.GridLayout", "overlayLayout", "java.swing.OverlayLayout", "springLayout", "java.swing.SpringLayout", "gridBagConstraints", "java.awt.GridBagConstraints", "gbc", "java.awt.GridBagConstraints", "boxLayout", "javax.swing.BoxLayout", "box", "javax.swing.Box", "hbox", "javax.swing.Box", "hglue", "java.awt.Component", "hstrut", "java.awt.Component", "vbox", "javax.swing.Box", "vglue", "java.awt.Component", "vstrut", "java.awt.Component", "glue", "java.awt.Component", "rigidArea", "java.awt.Component", "tableLayout", "groovy.swing.impl.TableLayoutRow", "tr", "groovy.swing.impl.TableLayoutRow", "td", "groovy.swing.impl.TableLayoutCell"};
    private static final ThreadLocal<List<PsiElement>> myElementsWithTypesBeingInferred = new ThreadLocal<List<PsiElement>>(){

        @Override
        protected List<PsiElement> initialValue() {
            return new ArrayList<PsiElement>();
        }
    };

    public GroovyPsiManager(Project project) {
        this.myProject = project;
        this.myCache = (GroovyShortNamesCache)((Object)ContainerUtil.findInstance((Object[])project.getExtensions(PsiShortNamesCache.EP_NAME), GroovyShortNamesCache.class));
        ((PsiManagerEx)PsiManager.getInstance((Project)this.myProject)).registerRunnableToRunOnAnyChange(new Runnable(){

            @Override
            public void run() {
                GroovyPsiManager.this.dropTypesCache();
            }
        });
        this.myTypeInferenceHelper = new TypeInferenceHelper(this.myProject);
        this.myProject.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                GroovyPsiManager.this.dropTypesCache();
                GroovyPsiManager.this.myRebuildGdkPending = true;
            }
        });
    }

    public TypeInferenceHelper getTypeInferenceHelper() {
        return this.myTypeInferenceHelper;
    }

    public void dropTypesCache() {
        this.myCalculatedTypes.clear();
    }

    @NotNull
    private Map<String, List<PsiMethod>> buildGDK() {
        HashMap newMap = new HashMap();
        this.addCategoryMethods(DEFAULT_METHODS_QNAME, (Map<String, List<PsiMethod>>)newMap, new NotNullFunction<PsiMethod, PsiMethod>(){

            @NotNull
            public PsiMethod fun(PsiMethod method) {
                GrGdkMethodImpl grGdkMethodImpl = new GrGdkMethodImpl(method, false);
                if (grGdkMethodImpl == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager$3.fun must not return null");
                }
                return grGdkMethodImpl;
            }
        });
        this.addCategoryMethods(DEFAULT_STATIC_METHODS_QNAME, (Map<String, List<PsiMethod>>)newMap, new NotNullFunction<PsiMethod, PsiMethod>(){

            @NotNull
            public PsiMethod fun(PsiMethod method) {
                GrGdkMethodImpl grGdkMethodImpl = new GrGdkMethodImpl(method, true);
                if (grGdkMethodImpl == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager$4.fun must not return null");
                }
                return grGdkMethodImpl;
            }
        });
        this.addSwingBuilderMethods((Map<String, List<PsiMethod>>)newMap);
        HashMap hashMap = newMap;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyPsiManager.buildGDK must not return null");
        }
        return hashMap;
    }

    public void addCategoryMethods(String fromClass, Map<String, List<PsiMethod>> toMap, NotNullFunction<PsiMethod, PsiMethod> converter) {
        PsiClass categoryClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fromClass, GlobalSearchScope.allScope((Project)this.myProject));
        if (categoryClass != null) {
            for (PsiMethod method : categoryClass.getMethods()) {
                if (method.isConstructor() || !method.hasModifierProperty("static") || !method.hasModifierProperty("public")) continue;
                GroovyPsiManager.addDefaultMethod(method, toMap, converter);
            }
        }
    }

    private static void addDefaultMethod(PsiMethod method, Map<String, List<PsiMethod>> map, NotNullFunction<PsiMethod, PsiMethod> converter) {
        if (!method.hasModifierProperty("public")) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        LOG.assertTrue(parameters.length > 0, (Object)method.getName());
        PsiType thisType = TypeConversionUtil.erasure((PsiType)parameters[0].getType());
        String thisCanonicalText = thisType.getCanonicalText();
        LOG.assertTrue(thisCanonicalText != null);
        List<PsiMethod> hisMethods = map.get(thisCanonicalText);
        if (hisMethods == null) {
            hisMethods = new ArrayList<PsiMethod>();
            map.put(thisCanonicalText, hisMethods);
        }
        hisMethods.add((PsiMethod)converter.fun((Object)method));
    }

    private void addSwingBuilderMethods(Map<String, List<PsiMethod>> myDefaultMethods) {
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        StringBuilder classText = new StringBuilder();
        classText.append("class SwingBuilder {\n");
        for (int i = 0; i < SWING_WIDGETS_METHODS.length / 2; ++i) {
            String methodName = SWING_WIDGETS_METHODS[2 * i];
            String returnTypeText = SWING_WIDGETS_METHODS[2 * i + 1];
            classText.append("public ").append(returnTypeText).append(' ').append(methodName).append("() {} \n");
        }
        classText.append('}');
        PsiJavaFile file = (PsiJavaFile)factory.createFileFromText("Dummy.java", classText.toString());
        PsiClass clazz = file.getClasses()[0];
        PsiMethod[] methods = clazz.getMethods();
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(methods.length);
        for (PsiMethod method : methods) {
            method.putUserData(GrMethod.BUILDER_METHOD, (Object)true);
            result.add(method);
        }
        myDefaultMethods.put(SWING_BUILDER_QNAME, result);
    }

    public List<PsiMethod> getDefaultMethods(String qName) {
        List<PsiMethod> methods;
        if (this.myRebuildGdkPending) {
            Map<String, List<PsiMethod>> gdk = this.buildGDK();
            if (this.myRebuildGdkPending) {
                this.myDefaultMethods = gdk;
                this.myRebuildGdkPending = false;
            }
        }
        if ((methods = this.myDefaultMethods.get(qName)) == null) {
            return Collections.emptyList();
        }
        return methods;
    }

    public List<PsiMethod> getDefaultMethods(PsiClass psiClass) {
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        this.getDefaultMethodsInner(psiClass, (Set<PsiClass>)new HashSet(), list);
        return list;
    }

    public void getDefaultMethodsInner(PsiClass psiClass, Set<PsiClass> watched, List<PsiMethod> methods) {
        if (watched.contains(psiClass)) {
            return;
        }
        watched.add(psiClass);
        methods.addAll(this.getDefaultMethods(psiClass.getQualifiedName()));
        for (PsiClass aClass : psiClass.getSupers()) {
            this.getDefaultMethodsInner(aClass, watched, methods);
        }
    }

    public static GroovyPsiManager getInstance(Project project) {
        return (GroovyPsiManager)ServiceManager.getService((Project)project, GroovyPsiManager.class);
    }

    @Nullable
    public <T extends GroovyPsiElement> PsiType getType(T element, Function<T, PsiType> calculator) {
        PsiType type = (PsiType)this.myCalculatedTypes.get(element);
        if (type == null) {
            type = (PsiType)calculator.fun(element);
            if (type == null) {
                type = PsiType.NULL;
            }
            type = (PsiType)ConcurrencyUtil.cacheOrGet(this.myCalculatedTypes, element, (Object)type);
        }
        if (!type.isValid()) {
            LOG.error("Type is invalid: " + type + "; element: " + element + " of class " + element.getClass());
        }
        return PsiType.NULL.equals(type) ? null : type;
    }

    public GrTypeDefinition getArrayClass() {
        if (this.myArrayClass == null) {
            try {
                this.myArrayClass = GroovyPsiElementFactory.getInstance(this.myProject).createTypeDefinition(SYNTHETIC_CLASS_TEXT);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.myArrayClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiType inferType(PsiElement element, Computable<PsiType> computable) {
        List<PsiElement> curr = myElementsWithTypesBeingInferred.get();
        try {
            curr.add(element);
            PsiType psiType = (PsiType)computable.compute();
            return psiType;
        }
        finally {
            curr.remove(element);
        }
    }

    public static boolean isTypeBeingInferred(PsiElement element) {
        return myElementsWithTypesBeingInferred.get().contains(element);
    }

    public GroovyShortNamesCache getNamesCache() {
        return this.myCache;
    }
}

