/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrLabeledStatementImpl
extends GroovyPsiElementImpl
implements GrLabeledStatement {
    public GrLabeledStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitLabeledStatement(this);
    }

    public String toString() {
        return "Labeled statement";
    }

    @Override
    @NotNull
    public String getLabelName() {
        GrLabel label = this.getLabel();
        String string = label.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl.getLabelName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public GrLabel getLabel() {
        GrLabel label = (GrLabel)this.findChildByClass(GrLabel.class);
        assert (label != null);
        GrLabel grLabel = label;
        if (grLabel == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl.getLabel must not return null");
        }
        return grLabel;
    }

    @Override
    @Nullable
    public GrStatement getStatement() {
        return (GrStatement)this.findChildByClass(GrStatement.class);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl.processDeclarations must not be null");
        }
        GrStatement statement = this.getStatement();
        return statement == null || statement == lastParent || statement.processDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this);
        if (localSearchScope == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl.getUseScope must not return null");
        }
        return localSearchScope;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrLabeledStatementImpl.setName must not be null");
        }
        GrLabel labelElement = this.getLabel();
        GrLabel newLabel = GroovyPsiElementFactory.getInstance(this.getProject()).createLabel(name);
        labelElement.replace(newLabel);
        return this;
    }

    public String getName() {
        return this.getLabelName();
    }
}

