/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrNamedArgumentSearchVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyBaseElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.params.GrParameterListImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public abstract class GrMethodBaseImpl<T extends NamedStub>
extends GroovyBaseElementImpl<T>
implements GrMethod {
    private static final Function<GrMethod, PsiType> ourTypesCalculator = new NullableFunction<GrMethod, PsiType>(){

        public PsiType fun(GrMethod method) {
            PsiType nominal = this.getNominalType(method);
            if (PsiType.VOID.equals(nominal)) {
                return nominal;
            }
            PsiType inferred = this.getInferredType(method);
            if (nominal == null) {
                if (inferred == null) {
                    return PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)method.getProject()), (GlobalSearchScope)method.getResolveScope());
                }
                return inferred;
            }
            if (inferred != null && inferred != PsiType.NULL && nominal.isAssignableFrom(inferred)) {
                return inferred;
            }
            return nominal;
        }

        @Nullable
        private PsiType getNominalType(GrMethod method) {
            GrTypeElement element = method.getReturnTypeElementGroovy();
            return element != null ? element.getType() : null;
        }

        @Nullable
        private PsiType getInferredType(GrMethod method) {
            GrOpenBlock block = method.getBlock();
            if (block == null) {
                return null;
            }
            if (GroovyPsiManager.isTypeBeingInferred(method)) {
                return null;
            }
            return GroovyPsiManager.inferType(method, new MethodTypeInferencer(block));
        }
    };

    protected GrMethodBaseImpl(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public GrMethodBaseImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitMethod(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.findChildByType(TokenSets.PROPERTY_NAMES);
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getNameIdentifierGroovy must not return null");
        }
        return psiElement;
    }

    @Override
    @Nullable
    public GrOpenBlock getBlock() {
        return (GrOpenBlock)this.findChildByClass(GrOpenBlock.class);
    }

    @Override
    public void setBlock(GrCodeBlock newBlock) {
        ASTNode newNode = newBlock.getNode().copyElement();
        GrOpenBlock oldBlock = this.getBlock();
        if (oldBlock == null) {
            this.getNode().addChild(newNode);
            return;
        }
        this.getNode().replaceChild(oldBlock.getNode(), newNode);
    }

    @Override
    public GrParameter[] getParameters() {
        GrParameterListImpl parameterList = (GrParameterListImpl)this.findChildByClass(GrParameterListImpl.class);
        if (parameterList != null) {
            return parameterList.getParameters();
        }
        return GrParameter.EMPTY_ARRAY;
    }

    @Override
    public GrTypeElement getReturnTypeElementGroovy() {
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    @Nullable
    public PsiType getDeclaredReturnType() {
        GrTypeElement typeElement = this.getReturnTypeElementGroovy();
        if (typeElement != null) {
            return typeElement.getType();
        }
        return null;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.processDeclarations must not be null");
        }
        for (GrTypeParameter grTypeParameter : this.getTypeParameters()) {
            if (ResolveUtil.processElement(processor, grTypeParameter)) continue;
            return false;
        }
        for (GrNamedElement grNamedElement : this.getParameters()) {
            if (ResolveUtil.processElement(processor, grNamedElement)) continue;
            return false;
        }
        processor.handleEvent(ResolveUtil.DECLARATION_SCOPE_PASSED, (Object)this);
        return true;
    }

    @Override
    public GrMember[] getMembers() {
        return new GrMember[]{this};
    }

    @Nullable
    public PsiType getReturnType() {
        return GroovyPsiManager.getInstance(this.getProject()).getType(this, ourTypesCalculator);
    }

    public Icon getIcon(int flags) {
        RowIcon baseIcon = GrMethodBaseImpl.createLayeredIcon((Icon)GroovyIcons.METHOD, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getMethodPresentation((PsiMethod)this);
    }

    @Nullable
    public PsiTypeElement getReturnTypeElement() {
        return null;
    }

    @Override
    @NotNull
    public GrParameterList getParameterList() {
        GrParameterList parameterList = (GrParameterList)this.findChildByType(GroovyElementTypes.PARAMETERS_LIST);
        assert (parameterList != null);
        GrParameterList grParameterList = parameterList;
        if (grParameterList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getParameterList must not return null");
        }
        return grParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        GrThrowsClause clause = (GrThrowsClause)this.findChildByClass(GrThrowsClause.class);
        assert (clause != null);
        GrThrowsClause grThrowsClause = clause;
        if (grThrowsClause == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getThrowsList must not return null");
        }
        return grThrowsClause;
    }

    @Nullable
    public PsiCodeBlock getBody() {
        return null;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isVarArgs() {
        GrParameter[] parameters = this.getParameters();
        return parameters.length > 0 && parameters[parameters.length - 1].isVarArgs();
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getSignature must not be null");
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getSignature must not return null");
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    private static void findSuperMethodRecursively(Set<PsiMethod> methods, PsiClass psiClass, boolean allowStatic, Set<PsiClass> visited, MethodSignature signature, @NotNull Set<MethodSignature> discoveredSupers) {
        PsiClassType[] superClassTypes;
        if (discoveredSupers == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.findSuperMethodRecursively must not be null");
        }
        if (psiClass == null) {
            return;
        }
        if (visited.contains(psiClass)) {
            return;
        }
        visited.add(psiClass);
        for (PsiClassType superClassType : superClassTypes = psiClass.getSuperTypes()) {
            PsiClass resolvedSuperClass = superClassType.resolve();
            if (resolvedSuperClass == null) continue;
            PsiMethod[] superClassMethods = resolvedSuperClass.getMethods();
            HashSet<MethodSignature> supers = new HashSet<MethodSignature>(3);
            for (PsiMethod superClassMethod : superClassMethods) {
                MethodSignature superMethodSignature = GrMethodBaseImpl.createMethodSignature(superClassMethod);
                if (!PsiImplUtil.isExtendsSignature(superMethodSignature, signature) || GrMethodBaseImpl.dominated(superMethodSignature, discoveredSupers) || !allowStatic && superClassMethod.getModifierList().hasExplicitModifier("static")) continue;
                methods.add(superClassMethod);
                supers.add(superMethodSignature);
                discoveredSupers.add(superMethodSignature);
            }
            GrMethodBaseImpl.findSuperMethodRecursively(methods, resolvedSuperClass, allowStatic, visited, signature, discoveredSupers);
            discoveredSupers.removeAll(supers);
        }
    }

    private static boolean dominated(MethodSignature signature, Iterable<MethodSignature> supersInInheritor) {
        for (MethodSignature sig1 : supersInInheritor) {
            if (!PsiImplUtil.isExtendsSignature(signature, sig1)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        this.findDeepestSuperMethodsForClass(methods, this);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.findDeepestSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    private void findDeepestSuperMethodsForClass(List<PsiMethod> collectedMethods, PsiMethod method) {
        PsiClassType[] superClassTypes;
        for (PsiClassType superClassType : superClassTypes = method.getContainingClass().getSuperTypes()) {
            PsiMethod[] superClassMethods;
            PsiClass resolvedSuperClass = superClassType.resolve();
            if (resolvedSuperClass == null) continue;
            for (PsiMethod superClassMethod : superClassMethods = resolvedSuperClass.getMethods()) {
                HierarchicalMethodSignature thisMethodSignature;
                HierarchicalMethodSignature superMethodSignature = superClassMethod.getHierarchicalMethodSignature();
                if (superMethodSignature.equals(thisMethodSignature = this.getHierarchicalMethodSignature()) && !superClassMethod.getModifierList().hasExplicitModifier("static")) {
                    GrMethodBaseImpl.checkForMethodOverriding(collectedMethods, superClassMethod);
                }
                this.findDeepestSuperMethodsForClass(collectedMethods, superClassMethod);
            }
        }
    }

    private static void checkForMethodOverriding(List<PsiMethod> collectedMethods, PsiMethod superClassMethod) {
        int i = 0;
        while (i < collectedMethods.size()) {
            PsiMethod collectedMethod = collectedMethods.get(i);
            if (collectedMethod.getContainingClass().equals(superClassMethod.getContainingClass()) || collectedMethod.getContainingClass().isInheritor(superClassMethod.getContainingClass(), true)) {
                collectedMethods.remove(collectedMethod);
                continue;
            }
            ++i;
        }
        collectedMethods.add(superClassMethod);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (boolean)checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (PsiClass)parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic((PsiMethod)this, (boolean)checkAccess);
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.findSuperMethodSignaturesIncludingStatic must not return null");
        }
        return list;
    }

    public static MethodSignature createMethodSignature(PsiMethod method) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType[] types = new PsiType[parameters.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = parameters[i].getType();
        }
        return MethodSignatureUtil.createMethodSignature((String)method.getName(), (PsiType[])types, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiMethod findDeepestSuperMethod() {
        return null;
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        GrModifierListImpl list = (GrModifierListImpl)this.findChildByClass(GrModifierListImpl.class);
        assert (list != null);
        GrModifierListImpl grModifierListImpl = list;
        if (grModifierListImpl == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getModifierList must not return null");
        }
        return grModifierListImpl;
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        PsiClass containingClass;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.hasModifierProperty must not be null");
        }
        if (name.equals("abstract") && (containingClass = this.getContainingClass()) != null && containingClass.isInterface()) {
            return true;
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NotNull
    public String getName() {
        String string = PsiImplUtil.getName(this);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getName must not return null");
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignature;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.setName must not be null");
        }
        PsiImplUtil.setName(name, this.getNameIdentifierGroovy());
        return this;
    }

    @Override
    public boolean hasTypeParameters() {
        return this.getTypeParameters().length > 0;
    }

    @Override
    @Nullable
    public GrTypeParameterList getTypeParameterList() {
        return (GrTypeParameterList)this.findChildByClass(GrTypeParameterList.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public GrTypeParameter[] getTypeParameters() {
        GrTypeParameter[] grTypeParameterArray;
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null) {
            grTypeParameterArray = list.getTypeParameters();
            if (grTypeParameterArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getTypeParameters must not return null");
            return grTypeParameterArray;
        }
        grTypeParameterArray = GrTypeParameter.EMPTY_ARRAY;
        if (GrTypeParameter.EMPTY_ARRAY != null) return grTypeParameterArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getTypeParameters must not return null");
    }

    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent = this.getParent();
        if (parent instanceof GrTypeDefinitionBody && (pparent = parent.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFileBase) {
            return ((GroovyFileBase)file).getScriptClass();
        }
        return null;
    }

    @Override
    @Nullable
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = com.intellij.psi.impl.PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    public PsiElement getOriginalElement() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return this;
        }
        PsiClass originalClass = (PsiClass)containingClass.getOriginalElement();
        PsiMethod originalMethod = originalClass.findMethodBySignature((PsiMethod)this, false);
        return originalMethod != null ? originalMethod : this;
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof GroovyFileImpl || parent instanceof GrTypeDefinitionBody) {
            super.delete();
            return;
        }
        throw new IncorrectOperationException("Invalid enclosing type definition");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<String>[] getNamedParametersArray() {
        Set<String>[] setArray;
        GrOpenBlock body = this.getBlock();
        if (body == null) {
            setArray = GrNamedArgumentSearchVisitor.EMPTY_SET_ARRAY;
            if (GrNamedArgumentSearchVisitor.EMPTY_SET_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getNamedParametersArray must not return null");
            return setArray;
        }
        GrParameter[] parameters = this.getParameters();
        if (parameters.length == 0) {
            setArray = GrNamedArgumentSearchVisitor.EMPTY_SET_ARRAY;
            if (GrNamedArgumentSearchVisitor.EMPTY_SET_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getNamedParametersArray must not return null");
            return setArray;
        }
        LinkedHashMap map = null;
        for (GrParameter parameter : parameters) {
            PsiType type = parameter.getTypeGroovy();
            GrTypeElement typeElement = parameter.getTypeElementGroovy();
            if (type != null && type.getPresentableText() != null && !type.getPresentableText().endsWith("Map") && typeElement != null) continue;
            PsiElement expression = parameter.getNameIdentifierGroovy();
            if (map == null) {
                map = new LinkedHashMap();
            }
            map.put(expression.getText(), new HashSet());
        }
        if (map == null) {
            setArray = GrNamedArgumentSearchVisitor.EMPTY_SET_ARRAY;
            if (GrNamedArgumentSearchVisitor.EMPTY_SET_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getNamedParametersArray must not return null");
            return setArray;
        }
        body.accept(new GrNamedArgumentSearchVisitor(map));
        setArray = map.values().toArray(GrNamedArgumentSearchVisitor.EMPTY_SET_ARRAY);
        if (setArray != null) return setArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl.getNamedParametersArray must not return null");
    }

    public PsiMethodReceiver getMethodReceiver() {
        return null;
    }

    public PsiType getReturnTypeNoResolve() {
        return this.getReturnType();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, (PsiElement)another);
    }
}

