/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.impl;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;

public class GrTypeDefinitionStubImpl
extends StubBase<GrTypeDefinition>
implements GrTypeDefinitionStub {
    private static final int ANONYMOUS = 1;
    private static final int INTERFACE = 2;
    private static final int ENUM = 4;
    private static final int ANNOTATION = 8;
    private static final int IS_IN_QUALIFIED_NEW = 16;
    private final StringRef myName;
    private final String[] mySuperClasses;
    private final StringRef myQualifiedName;
    private StringRef mySourceFileName;
    private final String[] myAnnotations;
    private final byte myFlags;

    public GrTypeDefinitionStubImpl(StubElement parent, String name, String[] supers, IStubElementType elementType, String qualifiedName, String[] annotations, byte flags) {
        super(parent, elementType);
        this.myAnnotations = annotations;
        this.myName = StringRef.fromString((String)name);
        this.mySuperClasses = supers;
        this.myQualifiedName = StringRef.fromString((String)qualifiedName);
        this.myFlags = flags;
    }

    @Override
    public String[] getSuperClassNames() {
        return this.mySuperClasses;
    }

    public String getName() {
        return StringRef.toString((StringRef)this.myName);
    }

    @Override
    public String[] getAnnotations() {
        return this.myAnnotations;
    }

    @Override
    public String getQualifiedName() {
        return StringRef.toString((StringRef)this.myQualifiedName);
    }

    @Override
    public String getSourceFileName() {
        return StringRef.toString((StringRef)this.mySourceFileName);
    }

    public void setSourceFileName(StringRef sourceFileName) {
        this.mySourceFileName = sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.mySourceFileName = StringRef.fromString((String)sourceFileName);
    }

    @Override
    public boolean isAnnotationType() {
        return (this.myFlags & 8) != 0;
    }

    @Override
    public boolean isAnonymous() {
        return (this.myFlags & 1) != 0;
    }

    @Override
    public boolean isAnonymousInQualifiedNew() {
        return (this.myFlags & 0x10) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.myFlags & 2) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.myFlags & 4) != 0;
    }

    @Override
    public byte getFlags() {
        return this.myFlags;
    }

    public static byte buildFlags(GrTypeDefinition typeDefinition) {
        byte flags = 0;
        if (typeDefinition.isAnonymous()) {
            flags = (byte)(flags | 1);
            assert (typeDefinition instanceof GrAnonymousClassDefinition);
            if (((GrAnonymousClassDefinition)typeDefinition).isInQualifiedNew()) {
                flags = (byte)(flags | 0x10);
            }
        }
        if (typeDefinition.isAnnotationType()) {
            flags = (byte)(flags | 8);
        }
        if (typeDefinition.isInterface()) {
            flags = (byte)(flags | 2);
        }
        if (typeDefinition.isEnum()) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }
}

