/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntTargetNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;

final class AntBuildFileNodeDescriptor
extends AntNodeDescriptor {
    private static final Icon ICON = IconLoader.getIcon((String)"/ant/build.png");
    private final AntBuildFileBase myBuildFile;
    private CompositeAppearance myAppearance;

    public AntBuildFileNodeDescriptor(Project project, NodeDescriptor parentDescriptor, AntBuildFileBase buildFile) {
        super(project, parentDescriptor);
        this.myBuildFile = buildFile;
    }

    public Object getElement() {
        return this.myBuildFile;
    }

    public AntBuildFile getBuildFile() {
        return this.myBuildFile;
    }

    public boolean update() {
        CompositeAppearance oldAppearence = this.myAppearance;
        this.myAppearance = new CompositeAppearance();
        this.myAppearance.getEnding().addText(this.myBuildFile.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        AntBuildModelBase buildModel = this.myBuildFile.getModelIfRegistered();
        if (buildModel != null) {
            AntTargetNodeDescriptor.addShortcutText(buildModel.getDefaultTargetActionId(), this.myAppearance);
        }
        this.myOpenIcon = this.myClosedIcon = ICON;
        this.myName = this.myBuildFile.getPresentableName();
        return !Comparing.equal((Object)this.myAppearance, (Object)oldAppearence);
    }

    @Override
    public void customize(SimpleColoredComponent component) {
        if (this.myAppearance != null) {
            this.myAppearance.customize(component);
        } else {
            super.customize(component);
        }
    }

    @Override
    public boolean isAutoExpand() {
        return this.myBuildFile.shouldExpand();
    }
}

