/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.refactoring;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.impl.AntBeforeRunTaskProvider;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;

public class AntTargetRenameListenerProvider
implements RefactoringElementListenerProvider {
    public RefactoringElementListener getListener(PsiElement element) {
        if (element instanceof AntTarget) {
            final String oldName = ((AntTarget)element).getName();
            return new RefactoringElementListener(){

                public void elementMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/refactoring/AntTargetRenameListenerProvider$1.elementMoved must not be null");
                    }
                }

                public void elementRenamed(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/refactoring/AntTargetRenameListenerProvider$1.elementRenamed must not be null");
                    }
                    String newName = ((AntTarget)newElement).getName();
                    if (!Comparing.equal((String)oldName, (String)newName)) {
                        AntConfiguration configuration = AntConfiguration.getInstance(newElement.getProject());
                        ((AntConfigurationImpl)configuration).handleTargetRename(oldName, newName);
                        for (BeforeRunTaskProvider provider : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)AntBeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)newElement.getProject())) {
                            if (!AntBeforeRunTaskProvider.ID.equals((Object)provider.getId())) continue;
                            ((AntBeforeRunTaskProvider)provider).handleTargetRename(oldName, newName);
                            break;
                        }
                    }
                }
            };
        }
        return null;
    }
}

