/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.SettingsUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Settings
implements SearchableConfigurable {
    private final Configuration myConfiguration;
    private SettingsUI mySettingsUI;

    Settings(Configuration configuration) {
        this.myConfiguration = configuration;
    }

    public String getDisplayName() {
        return "Language Injection";
    }

    @Nullable
    public Icon getIcon() {
        return IconLoader.getIcon((String)"icon.png");
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        Configurable child = this.mySettingsUI == null ? null : this.mySettingsUI.getSelectedChild();
        String topic = child != null ? child.getHelpTopic() : null;
        return topic != null ? topic : "IntelliLang.Configuration";
    }

    public JComponent createComponent() {
        ProjectManager projectManager = ProjectManager.getInstance();
        Project[] projects = projectManager.getOpenProjects();
        Project project = null;
        if (projects.length == 0) {
            project = projectManager.getDefaultProject();
        } else {
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            Window focusedWindow = windowManager.getMostRecentFocusedWindow();
            if (focusedWindow != null) {
                for (Project p : projects) {
                    Window w = windowManager.suggestParentWindow(p);
                    if (w != focusedWindow && !w.isAncestorOf(focusedWindow) && !focusedWindow.isAncestorOf(w)) continue;
                    project = p;
                    break;
                }
            }
            if (project == null) {
                project = projectManager.getDefaultProject();
            }
        }
        this.mySettingsUI = new SettingsUI(project, this.myConfiguration);
        return this.mySettingsUI.createComponent();
    }

    public boolean isModified() {
        return this.mySettingsUI != null && this.mySettingsUI.isModified();
    }

    public void apply() throws ConfigurationException {
        this.mySettingsUI.apply();
    }

    public void reset() {
        this.mySettingsUI.reset();
    }

    public void disposeUIResources() {
        this.mySettingsUI = null;
    }

    public String getId() {
        return "IntelliLang.Configuration";
    }

    public Runnable enableSearch(String option) {
        return null;
    }
}

