/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.states.Statistics;
import com.intellij.execution.junit2.states.TestState;
import com.intellij.execution.junit2.ui.Formatters;
import com.intellij.execution.junit2.ui.StatisticsTable;
import com.intellij.execution.junit2.ui.TestRenderer;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableCellState;
import com.intellij.util.ui.ColumnInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public abstract class TestColumnInfo
extends ColumnInfo
implements Comparator {
    private static final ColumnInfo TEST = new TestColumnInfo(ExecutionBundle.message((String)"junit.runing.info.test.column.name", (Object[])new Object[0])){

        @Override
        public String valueOfTest(TestProxy test) {
            return Formatters.printTest(test);
        }

        public TableCellRenderer getRenderer(Object o) {
            return new TestInfoRenderer();
        }

        public int compare(Object o1, Object o2) {
            return this.getTestName(o1).compareTo(this.getTestName(o2));
        }

        private String getTestName(Object o1) {
            return ((TestProxy)((Object)o1)).getInfo().getName();
        }
    };
    private static final ColumnInfo TIME = new StatisticsColumn(ExecutionBundle.message((String)"junit.runing.info.time.elapsed.column.name", (Object[])new Object[0])){

        @Override
        public String valueOfTest(TestProxy test) {
            return Formatters.statisticsFor(test).getTime();
        }

        @Override
        public int getAspect(Statistics statistics) {
            return statistics.getTime();
        }
    };
    private static final ColumnInfo MEMORY_DELTA = new StatisticsColumn(ExecutionBundle.message((String)"junit.runing.info.usage.delta.column.name", (Object[])new Object[0])){

        @Override
        public String valueOfTest(TestProxy test) {
            return Formatters.statisticsFor(test).getMemoryUsageDelta();
        }

        @Override
        public int getAspect(Statistics statistics) {
            return statistics.getMemoryUsage();
        }
    };
    private static final ColumnInfo BEFORE_MEMORY = new StatisticsColumn(ExecutionBundle.message((String)"junit.runing.info.usage.before.column.name", (Object[])new Object[0])){

        @Override
        public String valueOfTest(TestProxy test) {
            return Formatters.statisticsFor(test).getBeforeMemory();
        }

        @Override
        public int getAspect(Statistics statistics) {
            return statistics.getBeforeMemory();
        }
    };
    private static final ColumnInfo AFTER_MEMORY = new StatisticsColumn(ExecutionBundle.message((String)"junit.runing.info.usage.after.column.name", (Object[])new Object[0])){

        @Override
        public String valueOfTest(TestProxy test) {
            return Formatters.statisticsFor(test).getAfterMemory();
        }

        @Override
        public int getAspect(Statistics statistics) {
            return statistics.getAfterMemory();
        }
    };
    private static final ColumnInfo CHILDREN_STATES = new TestColumnInfo(ExecutionBundle.message((String)"junit.runing.info.results.column.name", (Object[])new Object[0])){

        @Override
        protected String valueOfTest(TestProxy test) {
            return "";
        }

        public int compare(Object o1, Object o2) {
            return this.defectCount(o1) - this.defectCount(o2);
        }

        private int defectCount(Object o1) {
            TestProxy test = (TestProxy)((Object)o1);
            return test.selectChildren(Filter.DEFECT).length;
        }

        public TableCellRenderer getRenderer(Object o) {
            return new CountDefectsRenderer();
        }
    };
    public static final ColumnInfo[] COLUMN_NAMES = new ColumnInfo[]{TEST, TIME, MEMORY_DELTA, BEFORE_MEMORY, AFTER_MEMORY, CHILDREN_STATES};

    public TestColumnInfo(String name) {
        super(name);
    }

    public Object valueOf(Object object) {
        return this.valueOfTest((TestProxy)((Object)object));
    }

    public Comparator getComparator() {
        return this;
    }

    protected abstract String valueOfTest(TestProxy var1);

    private static TestProxy getTestAtRow(JTable table, int row) {
        StatisticsTable tableModel = (StatisticsTable)((Object)table.getModel());
        return tableModel.getTestAt(row);
    }

    private static class CountDefectsRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final SimpleTextAttributes RUNNING_COLOR = new SimpleTextAttributes(0, Color.BLACK);
        private static final SimpleTextAttributes DEFECT_ATTRIBUTE = new SimpleTextAttributes(1, Color.RED);
        private final SimpleColoredRenderer myCounters = new SimpleColoredRenderer();
        private final SimpleColoredRenderer myProgressIndicator = new SimpleColoredRenderer();
        private final TableCellState myCellState = new TableCellState();
        private static final SimpleTextAttributes TERMINATED_ATTRIBUTE = new SimpleTextAttributes(1, Color.ORANGE);

        public CountDefectsRenderer() {
            super(new BorderLayout());
            this.add((Component)this.myProgressIndicator, "West");
            this.add((Component)this.myCounters, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myCellState.collectState(table, isSelected, hasFocus, row, column);
            this.myCellState.updateRenderer((JComponent)this);
            this.updateSubcomponent(this.myCounters);
            this.updateSubcomponent(this.myProgressIndicator);
            this.customizeCellRenderer(table, row);
            return this;
        }

        private void updateSubcomponent(SimpleColoredRenderer subRenderer) {
            subRenderer.clear();
            subRenderer.setCellState(this.myCellState);
            this.myCellState.updateRenderer((JComponent)subRenderer);
            subRenderer.setBorder(null);
        }

        private void customizeCellRenderer(JTable table, int row) {
            StatisticsTable model = (StatisticsTable)((Object)table.getModel());
            TestProxy test = model.getTestAt(row);
            if (test == null) {
                return;
            }
            if (test.getChildCount() == 0) {
                this.customizeTestCase(test);
            } else {
                this.customizeTestSuite(test);
            }
        }

        private void customizeTestSuite(TestProxy test) {
            int running = 0;
            int passed = 0;
            int errors = 0;
            int failed = 0;
            int ignored = 0;
            TestState suiteState = test.getState();
            List<TestProxy> testCases = test.getAllTests();
            for (TestProxy testCase : testCases) {
                TestProxy child = testCase;
                if (!child.isLeaf()) continue;
                TestState state = child.getState();
                if (state.isInProgress()) {
                    ++running;
                    continue;
                }
                if (state.isPassed()) {
                    ++passed;
                    continue;
                }
                if (state.getMagnitude() == 8) {
                    ++errors;
                    continue;
                }
                if (state.getMagnitude() == 5) {
                    ++ignored;
                    continue;
                }
                ++failed;
            }
            if (running > 0) {
                this.myProgressIndicator.append(ExecutionBundle.message((String)"junit.runing.info.left.to.run.count.tree.node", (Object[])new Object[]{running}), RUNNING_COLOR);
            }
            String separator = "";
            if (failed > 0) {
                this.myCounters.append(ExecutionBundle.message((String)"junit.runing.info.failed.count.message", (Object[])new Object[]{failed}), DEFECT_ATTRIBUTE);
                separator = " ";
            }
            if (errors > 0) {
                this.myCounters.append(separator + ExecutionBundle.message((String)"junit.runing.info.errors.count.message", (Object[])new Object[]{errors}), DEFECT_ATTRIBUTE);
                separator = " ";
            }
            if (ignored > 0) {
                this.myCounters.append(separator + ExecutionBundle.message((String)"junit.runing.info.ignored.count.message", (Object[])new Object[]{ignored}), TERMINATED_ATTRIBUTE);
                separator = " ";
            }
            if (passed > 0) {
                Color color = suiteState.isPassed() ? TestsUIUtil.PASSED_COLOR : Color.BLACK;
                this.myCounters.append(separator + ExecutionBundle.message((String)"junit.runing.info.passed.count.message", (Object[])new Object[]{passed}), new SimpleTextAttributes(1, color));
            }
        }

        private void customizeTestCase(TestProxy test) {
            TestState state = test.getState();
            if (state.isInProgress()) {
                this.myCounters.append(ExecutionBundle.message((String)"junit.runing.info.running.label", (Object[])new Object[0]), RUNNING_COLOR);
            } else if (state.isPassed()) {
                this.myCounters.append(ExecutionBundle.message((String)"junit.runing.info.passed.label", (Object[])new Object[0]), new SimpleTextAttributes(1, TestsUIUtil.PASSED_COLOR));
            } else if (state.getMagnitude() == 8) {
                this.myCounters.append(ExecutionBundle.message((String)"junit.runing.info.error.tree.node", (Object[])new Object[0]), DEFECT_ATTRIBUTE);
            } else if (state.getMagnitude() == 4) {
                this.myCounters.append(ExecutionBundle.message((String)"junit.runing.info.terminated.label", (Object[])new Object[0]), TERMINATED_ATTRIBUTE);
            } else if (state.getMagnitude() == 5) {
                this.myCounters.append(ExecutionBundle.message((String)"junit.runing.info.ignored.label", (Object[])new Object[0]), TERMINATED_ATTRIBUTE);
            } else {
                this.myCounters.append(ExecutionBundle.message((String)"junit.runing.info.assertion.tree.node", (Object[])new Object[0]), DEFECT_ATTRIBUTE);
            }
        }
    }

    private static class RightAlignedRenderer
    extends DefaultTableCellRenderer {
        private RightAlignedRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(4);
            return this;
        }
    }

    private static class TestInfoRenderer
    extends ColoredTableCellRenderer {
        private TestInfoRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            TestRenderer.renderTest(TestColumnInfo.getTestAtRow(table, row), (SimpleColoredComponent)this);
        }
    }

    private static abstract class StatisticsColumn
    extends TestColumnInfo {
        public StatisticsColumn(String name) {
            super(name);
        }

        public final int compare(Object o1, Object o2) {
            return this.getAspect(StatisticsColumn.getTestStatistics(o2)) - this.getAspect(StatisticsColumn.getTestStatistics(o1));
        }

        private static Statistics getTestStatistics(Object o1) {
            return ((TestProxy)((Object)o1)).getStatistics();
        }

        public TableCellRenderer getRenderer(Object o) {
            return new RightAlignedRenderer();
        }

        protected abstract int getAspect(Statistics var1);
    }
}

