/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import sun.jvm.hotspot.jdi.LineInfo;
import sun.jvm.hotspot.jdi.MethodImpl;
import sun.jvm.hotspot.jdi.MirrorImpl;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.jdi.SDE;
import sun.jvm.hotspot.jdi.StratumLineInfo;
import sun.jvm.hotspot.oops.Method;

public class LocationImpl
extends MirrorImpl
implements Location {
    private final ReferenceTypeImpl declaringType;
    private com.sun.jdi.Method method;
    private Method methodRef;
    private long codeIndex;
    private LineInfo baseLineInfo = null;
    private LineInfo otherLineInfo = null;

    LocationImpl(VirtualMachine vm, com.sun.jdi.Method method, long codeIndex) {
        super(vm);
        this.method = method;
        this.codeIndex = method.isNative() ? -1L : codeIndex;
        this.declaringType = (ReferenceTypeImpl)method.declaringType();
    }

    LocationImpl(VirtualMachine vm, ReferenceType declaringType, Method methodRef, long codeIndex) {
        super(vm);
        this.method = null;
        this.codeIndex = codeIndex;
        this.declaringType = (ReferenceTypeImpl)declaringType;
        this.methodRef = methodRef;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Location) {
            Location other = (Location)obj;
            return ((Object)this.method()).equals(other.method()) && this.codeIndex() == other.codeIndex() && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.method()).hashCode() + (int)this.codeIndex();
    }

    @Override
    public int compareTo(Location other) {
        int rc = this.method().compareTo(other.method());
        if (rc == 0) {
            long diff = this.codeIndex() - other.codeIndex();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
        return rc;
    }

    @Override
    public ReferenceType declaringType() {
        return this.declaringType;
    }

    @Override
    public com.sun.jdi.Method method() {
        if (this.method == null) {
            this.method = this.declaringType.getMethodMirror(this.methodRef);
            if (this.method.isNative()) {
                this.codeIndex = -1L;
            }
        }
        return this.method;
    }

    @Override
    public long codeIndex() {
        this.method();
        return this.codeIndex;
    }

    LineInfo getBaseLineInfo(SDE.Stratum stratum) {
        if (this.baseLineInfo != null) {
            return this.baseLineInfo;
        }
        MethodImpl methodImpl = (MethodImpl)this.method();
        LineInfo lineInfo = methodImpl.codeIndexToLineInfo(stratum, this.codeIndex());
        this.addBaseLineInfo(lineInfo);
        return lineInfo;
    }

    LineInfo getLineInfo(SDE.Stratum stratum) {
        if (stratum.isJava()) {
            return this.getBaseLineInfo(stratum);
        }
        LineInfo lineInfo = this.otherLineInfo;
        if (lineInfo != null && stratum.id().equals(lineInfo.liStratum())) {
            return lineInfo;
        }
        int baseLineNumber = this.lineNumber("Java");
        SDE.LineStratum lineStratum = stratum.lineStratum(this.declaringType, baseLineNumber);
        if (lineStratum != null && lineStratum.lineNumber() != -1) {
            lineInfo = new StratumLineInfo(stratum.id(), lineStratum.lineNumber(), lineStratum.sourceName(), lineStratum.sourcePath());
        } else {
            MethodImpl methodImpl = (MethodImpl)this.method();
            lineInfo = methodImpl.codeIndexToLineInfo(stratum, this.codeIndex());
        }
        this.addStratumLineInfo(lineInfo);
        return lineInfo;
    }

    void addStratumLineInfo(LineInfo lineInfo) {
        this.otherLineInfo = lineInfo;
    }

    void addBaseLineInfo(LineInfo lineInfo) {
        this.baseLineInfo = lineInfo;
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        return this.sourceName(this.vm.getDefaultStratum());
    }

    @Override
    public String sourceName(String stratumID) throws AbsentInformationException {
        return this.sourceName(this.declaringType.stratum(stratumID));
    }

    String sourceName(SDE.Stratum stratum) throws AbsentInformationException {
        return this.getLineInfo(stratum).liSourceName();
    }

    @Override
    public String sourcePath() throws AbsentInformationException {
        return this.sourcePath(this.vm.getDefaultStratum());
    }

    @Override
    public String sourcePath(String stratumID) throws AbsentInformationException {
        return this.sourcePath(this.declaringType.stratum(stratumID));
    }

    String sourcePath(SDE.Stratum stratum) throws AbsentInformationException {
        return this.getLineInfo(stratum).liSourcePath();
    }

    @Override
    public int lineNumber() {
        return this.lineNumber(this.vm.getDefaultStratum());
    }

    @Override
    public int lineNumber(String stratumID) {
        return this.lineNumber(this.declaringType.stratum(stratumID));
    }

    int lineNumber(SDE.Stratum stratum) {
        return this.getLineInfo(stratum).liLineNumber();
    }

    @Override
    public String toString() {
        if (this.lineNumber() == -1) {
            return this.method().toString() + "+" + this.codeIndex();
        }
        return this.declaringType().name() + ":" + this.lineNumber();
    }
}

