/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.LocalVariableTableElement;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.StackValueCollection;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.soql.DefaultScriptObject;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;
import sun.jvm.hotspot.utilities.soql.JSJavaThread;
import sun.jvm.hotspot.utilities.soql.JSMap;

public class JSJavaFrame
extends DefaultScriptObject {
    private static final int FIELD_METHOD = 0;
    private static final int FIELD_BCI = 1;
    private static final int FIELD_LINE_NUMBER = 2;
    private static final int FIELD_LOCALS = 3;
    private static final int FIELD_THIS_OBJECT = 4;
    private static final int FIELD_THREAD = 5;
    private static final int FIELD_UNDEFINED = -1;
    private static Map fields = new HashMap();
    private final JavaVFrame jvf;
    private final JSJavaFactory factory;
    private JSMap localsCache;

    public JSJavaFrame(JavaVFrame jvf, JSJavaFactory fac) {
        this.jvf = jvf;
        this.factory = fac;
    }

    @Override
    public Object get(String name) {
        int fieldID = JSJavaFrame.getFieldID(name);
        switch (fieldID) {
            case 0: {
                return this.getMethod();
            }
            case 1: {
                return new Integer(this.getBCI());
            }
            case 2: {
                return new Integer(this.getLineNumber());
            }
            case 3: {
                return this.getLocals();
            }
            case 4: {
                return this.getThisObject();
            }
            case 5: {
                return this.getThread();
            }
        }
        return super.get(name);
    }

    @Override
    public Object[] getIds() {
        Object[] fieldNames = fields.keySet().toArray();
        Object[] superFields = super.getIds();
        Object[] res = new Object[fieldNames.length + superFields.length];
        System.arraycopy(fieldNames, 0, res, 0, fieldNames.length);
        System.arraycopy(superFields, 0, res, fieldNames.length, superFields.length);
        return res;
    }

    @Override
    public boolean has(String name) {
        if (JSJavaFrame.getFieldID(name) != -1) {
            return true;
        }
        return super.has(name);
    }

    @Override
    public void put(String name, Object value) {
        if (JSJavaFrame.getFieldID(name) == -1) {
            super.put(name, value);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Frame (method=");
        buf.append(this.jvf.getMethod().externalNameAndSignature());
        buf.append(", bci=");
        buf.append(this.getBCI());
        buf.append(", line=");
        buf.append(this.getLineNumber());
        buf.append(')');
        return buf.toString();
    }

    private static void addField(String name, int fieldId) {
        fields.put(name, new Integer(fieldId));
    }

    private static int getFieldID(String name) {
        Integer res = (Integer)fields.get(name);
        return res != null ? res : -1;
    }

    private JSJavaObject getMethod() {
        return this.factory.newJSJavaObject(this.jvf.getMethod());
    }

    private int getBCI() {
        return this.jvf.getBCI();
    }

    private int getLineNumber() {
        int bci = this.jvf.getBCI();
        if (bci == -1) {
            return 0;
        }
        int lineNum = this.jvf.getMethod().getLineNumberFromBCI(bci);
        return lineNum <= 0 ? 0 : lineNum;
    }

    private synchronized JSMap getLocals() {
        if (this.localsCache == null) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            this.localsCache = this.factory.newJSMap(map);
            StackValueCollection values = this.jvf.getLocals();
            Method method = this.jvf.getMethod();
            if (method.isNative() || !method.hasLocalVariableTable() || values == null) {
                return this.localsCache;
            }
            LocalVariableTableElement[] localVars = method.getLocalVariableTable();
            int bci = this.getBCI();
            ArrayList<LocalVariableTableElement> visibleVars = new ArrayList<LocalVariableTableElement>(0);
            for (int i = 0; i < localVars.length; ++i) {
                LocalVariableTableElement cur = localVars[i];
                if (cur.getStartBCI() < bci || cur.getLength() <= 0) continue;
                visibleVars.add(cur);
            }
            OopHandle handle = null;
            ObjectHeap heap = VM.getVM().getObjectHeap();
            for (LocalVariableTableElement cur : visibleVars) {
                String name = method.getConstants().getSymbolAt(cur.getNameCPIndex()).asString();
                int slot = cur.getSlot();
                String signature = method.getConstants().getSymbolAt(cur.getDescriptorCPIndex()).asString();
                BasicType variableType = BasicType.charToBasicType(signature.charAt(0));
                Object value = null;
                if (variableType == BasicType.T_BOOLEAN) {
                    value = values.booleanAt(slot);
                } else if (variableType == BasicType.T_CHAR) {
                    value = new Character(values.charAt(slot));
                } else if (variableType == BasicType.T_FLOAT) {
                    value = new Float(values.floatAt(slot));
                } else if (variableType == BasicType.T_DOUBLE) {
                    value = new Double(values.doubleAt(slot));
                } else if (variableType == BasicType.T_BYTE) {
                    value = new Byte(values.byteAt(slot));
                } else if (variableType == BasicType.T_SHORT) {
                    value = new Short(values.shortAt(slot));
                } else if (variableType == BasicType.T_INT) {
                    value = new Integer(values.intAt(slot));
                } else if (variableType == BasicType.T_LONG) {
                    value = new Long(values.longAt(slot));
                } else if (variableType == BasicType.T_OBJECT || variableType == BasicType.T_ARRAY) {
                    handle = values.oopHandleAt(slot);
                    value = this.factory.newJSJavaObject(heap.newOop(handle));
                }
                map.put(name, (Boolean)value);
            }
        }
        return this.localsCache;
    }

    private JSJavaObject getThisObject() {
        Method method = this.jvf.getMethod();
        if (method.isStatic()) {
            return null;
        }
        StackValueCollection values = this.jvf.getLocals();
        if (values != null) {
            OopHandle handle = values.oopHandleAt(0);
            ObjectHeap heap = VM.getVM().getObjectHeap();
            return this.factory.newJSJavaObject(heap.newOop(handle));
        }
        return null;
    }

    private JSJavaThread getThread() {
        return this.factory.newJSJavaThread(this.jvf.getThread());
    }

    static {
        JSJavaFrame.addField("method", 0);
        JSJavaFrame.addField("bci", 1);
        JSJavaFrame.addField("line", 2);
        JSJavaFrame.addField("locals", 3);
        JSJavaFrame.addField("thisObject", 4);
        JSJavaFrame.addField("thread", 5);
    }
}

