/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveAction
extends JosmAction {
    private Direction myDirection;

    private static Object calltosupermustbefirststatementinconstructor(Direction dir, boolean text) {
        Shortcut sc;
        String directiontext;
        if (dir == Direction.UP) {
            directiontext = I18n.tr("up");
            sc = Shortcut.registerShortcut("core:moveup", I18n.tr("Move objects {0}", directiontext), 38, 12);
        } else if (dir == Direction.DOWN) {
            directiontext = I18n.tr("down");
            sc = Shortcut.registerShortcut("core:movedown", I18n.tr("Move objects {0}", directiontext), 40, 12);
        } else if (dir == Direction.LEFT) {
            directiontext = I18n.tr("left");
            sc = Shortcut.registerShortcut("core:moveleft", I18n.tr("Move objects {0}", directiontext), 37, 12);
        } else {
            directiontext = I18n.tr("right");
            sc = Shortcut.registerShortcut("core:moveright", I18n.tr("Move objects {0}", directiontext), 39, 12);
        }
        if (text) {
            return directiontext;
        }
        return sc;
    }

    public MoveAction(Direction dir) {
        super(I18n.tr("Move {0}", MoveAction.calltosupermustbefirststatementinconstructor(dir, true)), null, I18n.tr("Moves Objects {0}", MoveAction.calltosupermustbefirststatementinconstructor(dir, true)), (Shortcut)MoveAction.calltosupermustbefirststatementinconstructor(dir, false), true);
        this.myDirection = dir;
        this.putValue("help", HelpUtil.ht("/Action/Move"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Command c;
        if (!Main.isDisplayingMapView()) {
            return;
        }
        EastNorth en1 = Main.map.mapView.getEastNorth(100, 100);
        EastNorth en2 = Main.map.mapView.getEastNorth(101, 101);
        double distx = en2.east() - en1.east();
        double disty = en2.north() - en1.north();
        switch (this.myDirection) {
            case UP: {
                distx = 0.0;
                disty = -disty;
                break;
            }
            case DOWN: {
                distx = 0.0;
                break;
            }
            case LEFT: {
                disty = 0.0;
                distx = -distx;
                break;
            }
            default: {
                disty = 0.0;
            }
        }
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        Collection<Node> affectedNodes = AllNodesVisitor.getAllNodes(selection);
        Command command = c = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
        if (c instanceof MoveCommand && ((Object)affectedNodes).equals(((MoveCommand)c).getParticipatingPrimitives())) {
            ((MoveCommand)c).moveAgain(distx, disty);
        } else {
            c = new MoveCommand(selection, distx, disty);
            Main.main.undoRedo.add(c);
        }
        for (Node n : affectedNodes) {
            if (!n.getCoor().isOutSideWorld()) continue;
            ((MoveCommand)c).moveAgain(-distx, -disty);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world."), I18n.tr("Warning"), 2);
            return;
        }
        Main.map.mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        LEFT,
        RIGHT,
        DOWN;

    }
}

