/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.RelationMember;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryRelation
extends HistoryOsmPrimitive {
    private ArrayList<RelationMember> members = new ArrayList();

    public HistoryRelation(long id, long version, boolean visible, String user, long uid, long changesetId, Date timestamp) throws IllegalArgumentException {
        super(id, version, visible, user, uid, changesetId, timestamp);
    }

    public HistoryRelation(long id, long version, boolean visible, String user, long uid, long changesetId, Date timestamp, ArrayList<RelationMember> members) {
        this(id, version, visible, user, uid, changesetId, timestamp);
        if (members != null) {
            this.members.addAll(members);
        }
    }

    public List<RelationMember> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public int getNumMembers() {
        return this.members.size();
    }

    public RelationMember getRelationMember(int idx) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.members.size()) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Parameter {0} not in range 0..{1}. Got ''{2}''.", "idx", this.members.size(), idx));
        }
        return this.members.get(idx);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    public void addMember(RelationMember member) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(member, "member");
        this.members.add(member);
    }

    @Override
    public String getDisplayName(HistoryNameFormatter formatter) {
        return formatter.format(this);
    }
}

