/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class BookmarkList
extends JList {
    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
        this.setCellRenderer(new BookmarkCellRenderer());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.removeAllElements();
        Collection<Collection<String>> args = Main.pref.getArray("bookmarks", null);
        if (args != null) {
            LinkedList<Bookmark> bookmarks = new LinkedList<Bookmark>();
            for (Collection<String> entry : args) {
                try {
                    bookmarks.add(new Bookmark(entry));
                }
                catch (Exception e) {
                    System.err.println(I18n.tr("Error reading bookmark entry: %s", e.getMessage()));
                }
            }
            Collections.sort(bookmarks);
            for (Bookmark b : bookmarks) {
                model.addElement(b);
            }
            return;
        } else {
            if (Main.applet) return;
            File bookmarkFile = new File(Main.pref.getPreferencesDir(), "bookmarks");
            try {
                LinkedList<Bookmark> bookmarks = new LinkedList<Bookmark>();
                if (!bookmarkFile.exists()) return;
                System.out.println("Try loading obsolete bookmarks file");
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bookmarkFile), "utf-8"));
                String line = in.readLine();
                while (line != null) {
                    Matcher m = Pattern.compile("^(.+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)$").matcher(line);
                    if (!m.matches() || m.groupCount() != 5) {
                        System.err.println(I18n.tr("Error: Unexpected line ''{0}'' in bookmark file ''{1}''", line, bookmarkFile.toString()));
                    } else {
                        Bookmark b = new Bookmark();
                        b.setName(m.group(1));
                        double[] values = new double[4];
                        for (int i = 0; i < 4; ++i) {
                            try {
                                values[i] = Double.parseDouble(m.group(i + 2));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                System.err.println(I18n.tr("Error: Illegal double value ''{0}'' on line ''{1}'' in bookmark file ''{2}''", m.group(i + 2), line, bookmarkFile.toString()));
                            }
                        }
                        b.setArea(new Bounds(values));
                        bookmarks.add(b);
                    }
                    line = in.readLine();
                }
                in.close();
                Collections.sort(bookmarks);
                for (Bookmark b : bookmarks) {
                    model.addElement(b);
                }
                this.save();
                System.out.println("Removing obsolete bookmarks file");
                bookmarkFile.delete();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not read bookmarks from<br>''{0}''<br>Error was: {1}</html>", bookmarkFile.toString(), e.getMessage()), I18n.tr("Error"), 0);
            }
        }
    }

    public void save() {
        LinkedList<Collection<String>> coll = new LinkedList<Collection<String>>();
        for (Object o : ((DefaultListModel)this.getModel()).toArray()) {
            String[] array = new String[5];
            Bookmark b = (Bookmark)o;
            array[0] = b.getName();
            Bounds area = b.getArea();
            array[1] = String.valueOf(area.getMin().lat());
            array[2] = String.valueOf(area.getMin().lon());
            array[3] = String.valueOf(area.getMax().lat());
            array[4] = String.valueOf(area.getMax().lon());
            coll.add(Arrays.asList(array));
        }
        Main.pref.putArray("bookmarks", coll);
    }

    static class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ImageIcon icon;

        public BookmarkCellRenderer() {
            this.setOpaque(true);
            this.icon = ImageProvider.get("dialogs", "bookmark");
            this.setIcon(this.icon);
        }

        protected void renderColor(boolean selected) {
            if (selected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
        }

        protected String buildToolTipText(Bookmark b) {
            Bounds area = b.getArea();
            StringBuffer sb = new StringBuffer();
            sb.append("<html>min[latitude,longitude]=<strong>[").append(area.getMin().lat()).append(",").append(area.getMin().lon()).append("]</strong>").append("<br>").append("max[latitude,longitude]=<strong>[").append(area.getMax().lat()).append(",").append(area.getMax().lon()).append("]</strong>").append("</html>");
            return sb.toString();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Bookmark b = (Bookmark)value;
            this.renderColor(isSelected);
            this.setText(b.getName());
            this.setToolTipText(this.buildToolTipText(b));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bookmark
    implements Comparable<Bookmark> {
        private String name;
        private Bounds area;

        public Bookmark(Collection<String> list) throws NumberFormatException, IllegalArgumentException {
            ArrayList<String> array = new ArrayList<String>(list);
            if (array.size() < 5) {
                throw new IllegalArgumentException(I18n.tr("Wrong number of arguments for bookmark"));
            }
            this.name = array.get(0);
            this.area = new Bounds(Double.parseDouble(array.get(1)), Double.parseDouble(array.get(2)), Double.parseDouble(array.get(3)), Double.parseDouble(array.get(4)));
        }

        public Bookmark() {
            this.area = null;
            this.name = null;
        }

        public Bookmark(Bounds area) {
            this.area = area;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Bookmark b) {
            return this.name.toLowerCase().compareTo(b.name.toLowerCase());
        }

        public Bounds getArea() {
            return this.area;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setArea(Bounds area) {
            this.area = area;
        }
    }
}

