/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lib.uno.helper.PropertySetMixin;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.report.meta.XFunctionCategory;
import com.sun.star.report.meta.XFunctionDescription;
import com.sun.star.report.pentaho.StarFunctionDescription;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.Locale;
import java.util.MissingResourceException;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.function.FunctionCategory;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;

public final class StarFunctionCategory
extends WeakBase
implements XFunctionCategory {
    private final XComponentContext m_xContext;
    private final PropertySetMixin m_prophlp;
    private final int m_Number;
    private final FunctionCategory category;
    private final FunctionRegistry functionRegistry;
    private final String[] functions;
    private final DefaultFormulaContext defaultContext;
    private final Locale defaultLocale;

    public StarFunctionCategory(DefaultFormulaContext defaultFormulaContext, XComponentContext xComponentContext, FunctionRegistry functionRegistry, int n, FunctionCategory functionCategory) {
        Locale locale;
        this.defaultContext = defaultFormulaContext;
        this.m_xContext = xComponentContext;
        this.m_Number = n;
        this.category = functionCategory;
        this.functionRegistry = functionRegistry;
        try {
            functionCategory.getDisplayName(defaultFormulaContext.getLocalizationContext().getLocale());
            locale = defaultFormulaContext.getLocalizationContext().getLocale();
        }
        catch (MissingResourceException missingResourceException) {
            locale = Locale.ENGLISH;
            try {
                functionCategory.getDisplayName(locale);
            }
            catch (MissingResourceException missingResourceException2) {
                // empty catch block
            }
        }
        this.defaultLocale = locale;
        this.functions = functionRegistry.getFunctionNamesByCategory(functionCategory);
        this.m_prophlp = new PropertySetMixin(this.m_xContext, (XInterface)this, new Type(XFunctionCategory.class), null);
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this.m_prophlp.getPropertySetInfo();
    }

    public void setPropertyValue(String string, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.m_prophlp.setPropertyValue(string, object);
    }

    public Object getPropertyValue(String string) throws UnknownPropertyException, WrappedTargetException {
        return this.m_prophlp.getPropertyValue(string);
    }

    public void addPropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addPropertyChangeListener(string, xPropertyChangeListener);
    }

    public void removePropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removePropertyChangeListener(string, xPropertyChangeListener);
    }

    public void addVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addVetoableChangeListener(string, xVetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removeVetoableChangeListener(string, xVetoableChangeListener);
    }

    public Type getElementType() {
        return new Type(XFunctionDescription.class);
    }

    public boolean hasElements() {
        return this.functions.length != 0;
    }

    public int getCount() {
        return this.functions.length;
    }

    public Object getByIndex(int n) throws IndexOutOfBoundsException, WrappedTargetException {
        return this.getFunction(n);
    }

    public int getNumber() {
        return this.m_Number;
    }

    public String getName() {
        try {
            return this.category.getDisplayName(this.defaultLocale);
        }
        catch (Exception exception) {
            return "Missing category for number " + this.m_Number;
        }
    }

    public XFunctionDescription getFunction(int n) throws IndexOutOfBoundsException, WrappedTargetException {
        if (n >= this.functions.length) {
            throw new java.lang.IndexOutOfBoundsException();
        }
        return new StarFunctionDescription(this.defaultContext, this.m_xContext, this, this.functionRegistry.getMetaData(this.functions[n]));
    }
}

