/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.SheetSettings;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BeginningOfFile;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BlankCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BoolErrCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BoundSheet;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.CodePage;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ColInfo;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefinedName;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Eof;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ExtendedFormat;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FloatNumber;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FontDescription;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Formula;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.LabelCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Row;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.StringValue;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Window1;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Worksheet;
import org.openoffice.xmerge.util.Debug;

public class Workbook
implements Document,
OfficeConstants {
    private Vector fonts = new Vector();
    private Vector extendedFormats = new Vector();
    private Vector worksheets = new Vector();
    private Vector boundsheets = new Vector();
    private Vector definedNames = new Vector();
    private static final CodePage cp = new CodePage();
    private static final Window1 win1 = new Window1();
    private static final BeginningOfFile bof = new BeginningOfFile(true);
    private static final Eof eof = new Eof();
    private String fileName;

    public Workbook(String string) throws IOException {
        this.fileName = string + ".pxl";
        Format format = new Format();
        FontDescription fontDescription = new FontDescription(format);
        this.fonts.add(fontDescription);
        ExtendedFormat extendedFormat = new ExtendedFormat(0, format);
        this.extendedFormats.add(extendedFormat);
    }

    public Workbook(String string, InputStream inputStream) throws IOException {
        this.read(inputStream);
        this.fileName = string;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        Object object;
        bof.write(outputStream);
        cp.write(outputStream);
        Enumeration enumeration = this.definedNames.elements();
        while (enumeration.hasMoreElements()) {
            object = (DefinedName)enumeration.nextElement();
            ((DefinedName)object).write(outputStream);
        }
        win1.write(outputStream);
        enumeration = this.fonts.elements();
        while (enumeration.hasMoreElements()) {
            object = (FontDescription)enumeration.nextElement();
            ((FontDescription)object).write(outputStream);
        }
        enumeration = this.extendedFormats.elements();
        while (enumeration.hasMoreElements()) {
            object = (ExtendedFormat)enumeration.nextElement();
            ((ExtendedFormat)object).write(outputStream);
        }
        enumeration = this.boundsheets.elements();
        while (enumeration.hasMoreElements()) {
            object = (BoundSheet)enumeration.nextElement();
            ((BoundSheet)object).write(outputStream);
        }
        eof.write(outputStream);
        enumeration = this.worksheets.elements();
        while (enumeration.hasMoreElements()) {
            object = (Worksheet)enumeration.nextElement();
            ((Worksheet)object).write(outputStream);
        }
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
        boolean bl = false;
        int n = 0;
        block10: while (!bl) {
            n = inputStream.read();
            if (n == -1) {
                Debug.log(4, "End of file reached");
                break;
            }
            switch (n) {
                case 24: {
                    Debug.log(4, "NAME: Defined Name (18h)");
                    DefinedName definedName = new DefinedName(inputStream, this);
                    this.definedNames.add(definedName);
                    continue block10;
                }
                case 9: {
                    Debug.log(4, "BOF Record");
                    bof.read(inputStream);
                    continue block10;
                }
                case 10: {
                    Debug.log(4, "EOF Marker");
                    eof.read(inputStream);
                    Worksheet worksheet = new Worksheet(this);
                    while (worksheet.read(inputStream)) {
                        this.worksheets.add(worksheet);
                        worksheet = new Worksheet(this);
                    }
                    continue block10;
                }
                case 49: {
                    Debug.log(4, "FONT: Font Description (31h)");
                    FontDescription fontDescription = new FontDescription(inputStream);
                    this.fonts.add(fontDescription);
                    continue block10;
                }
                case 61: {
                    Debug.log(4, "WINDOW1: Window Information (3Dh) [PXL 2.0]");
                    win1.read(inputStream);
                    continue block10;
                }
                case 66: {
                    Debug.log(4, "CODEPAGE : Codepage and unknown fields (42h)");
                    cp.read(inputStream);
                    continue block10;
                }
                case 133: {
                    Debug.log(4, "BOUNDSHEET: Sheet Information (85h)");
                    BoundSheet boundSheet = new BoundSheet(inputStream);
                    this.boundsheets.add(boundSheet);
                    continue block10;
                }
                case 224: {
                    Debug.log(4, "XF: Extended Format (E0h) [PXL 2.0]");
                    ExtendedFormat extendedFormat = new ExtendedFormat(inputStream);
                    this.extendedFormats.add(extendedFormat);
                    continue block10;
                }
            }
            n = inputStream.read();
        }
        inputStream.close();
    }

    public int addFont(FontDescription fontDescription) {
        boolean bl = false;
        int n = 0;
        Enumeration enumeration = this.fonts.elements();
        while (enumeration.hasMoreElements()) {
            FontDescription fontDescription2 = (FontDescription)enumeration.nextElement();
            if (fontDescription2.compareTo(fontDescription)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.fonts.add(fontDescription);
        }
        return n;
    }

    public int addExtendedFormat(Format format) throws IOException {
        FontDescription fontDescription = new FontDescription(format);
        int n = this.addFont(fontDescription);
        ExtendedFormat extendedFormat = new ExtendedFormat(n, format);
        boolean bl = false;
        int n2 = 0;
        Enumeration enumeration = this.extendedFormats.elements();
        while (enumeration.hasMoreElements()) {
            ExtendedFormat extendedFormat2 = (ExtendedFormat)enumeration.nextElement();
            if (extendedFormat.compareTo(extendedFormat2)) {
                bl = true;
                break;
            }
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            this.extendedFormats.add(extendedFormat);
        }
        return n2;
    }

    public Worksheet getWorksheet(int n) {
        return (Worksheet)this.worksheets.elementAt(n);
    }

    public FontDescription getFontDescription(int n) {
        return (FontDescription)this.fonts.elementAt(n);
    }

    public ExtendedFormat getExtendedFormat(int n) {
        return (ExtendedFormat)this.extendedFormats.elementAt(n);
    }

    public Enumeration getDefinedNames() {
        return this.definedNames.elements();
    }

    public BookSettings getSettings() {
        Object object;
        Vector<SheetSettings> vector = new Vector<SheetSettings>();
        int n = 0;
        Object object2 = this.worksheets.elements();
        while (object2.hasMoreElements()) {
            object = (Worksheet)object2.nextElement();
            SheetSettings sheetSettings = ((Worksheet)object).getSettings();
            sheetSettings.setSheetName(this.getSheetName(n++));
            vector.add(sheetSettings);
        }
        object2 = new BookSettings(vector);
        object = this.getSheetName(win1.getActiveSheet());
        ((BookSettings)object2).setActiveSheet((String)object);
        return object2;
    }

    public Vector getWorksheetNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.boundsheets.size(); ++i) {
            vector.add(this.getSheetName(i));
        }
        return vector;
    }

    public String getSheetName(int n) {
        BoundSheet boundSheet = (BoundSheet)this.boundsheets.elementAt(n);
        return boundSheet.getSheetName();
    }

    public void addWorksheet(String string) throws IOException {
        BoundSheet boundSheet = new BoundSheet(string);
        this.boundsheets.add(boundSheet);
        Worksheet worksheet = new Worksheet();
        this.worksheets.add(worksheet);
    }

    public void addCell(int n, int n2, Format format, String string) throws IOException {
        Worksheet worksheet = (Worksheet)this.worksheets.elementAt(this.worksheets.size() - 1);
        int n3 = this.addExtendedFormat(format);
        String string2 = format.getCategory();
        Debug.log(4, "Cell Format: " + format);
        Debug.log(4, "Row : " + n);
        Debug.log(4, "Col : " + n2);
        if (string.startsWith("=")) {
            try {
                Formula formula = new Formula(n, n2, string, n3, format, this);
                worksheet.addCell(formula);
                if (string2.equalsIgnoreCase("string")) {
                    StringValue stringValue = new StringValue(format.getValue());
                    worksheet.addCell(stringValue);
                }
            }
            catch (Exception exception) {
                Debug.log(4, "Parsing Exception thrown : " + exception.getMessage());
                BoolErrCell boolErrCell = new BoolErrCell(n, n2, n3, 42, 1);
                worksheet.addCell(boolErrCell);
            }
        } else if (string2.equalsIgnoreCase("float")) {
            try {
                FloatNumber floatNumber = new FloatNumber(n, n2, string, n3);
                worksheet.addCell(floatNumber);
            }
            catch (Exception exception) {
                Debug.log(4, "Error could not parse Float " + string);
                LabelCell labelCell = new LabelCell(n, n2, string, n3);
                worksheet.addCell(labelCell);
            }
        } else if (string.length() == 0) {
            Debug.log(4, "Blank Cell");
            BlankCell blankCell = new BlankCell(n, n2, n3);
            worksheet.addCell(blankCell);
        } else {
            Debug.log(4, "Label Cell : " + string);
            LabelCell labelCell = new LabelCell(n, n2, string, n3);
            worksheet.addCell(labelCell);
        }
    }

    public void addColInfo(Vector vector) throws IOException {
        Worksheet worksheet = (Worksheet)this.worksheets.elementAt(this.worksheets.size() - 1);
        int n = 0;
        int n2 = 0;
        Debug.log(4, "Workbook: addColInfo()");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ColumnRowInfo columnRowInfo = (ColumnRowInfo)enumeration.nextElement();
            int n3 = 0;
            int n4 = columnRowInfo.getSize();
            int n5 = columnRowInfo.getRepeated();
            if (columnRowInfo.isColumn()) {
                Debug.log(4, "Workbook: adding ColInfo width = " + n4);
                ColInfo colInfo = new ColInfo(n, n + n5 - 1, n4, n3);
                worksheet.addCol(colInfo);
                n += n5;
                continue;
            }
            if (!columnRowInfo.isRow()) continue;
            Debug.log(4, "Workbook: adding Row Height = " + n4);
            if (!columnRowInfo.isDefaultSize()) {
                for (int i = 0; i < n5; ++i) {
                    Row row = new Row(n2++, n4, columnRowInfo.isUserDefined());
                    worksheet.addRow(row);
                }
                continue;
            }
            n2 += n5;
        }
    }

    public void addNameDefinition(NameDefinition nameDefinition) throws IOException {
        DefinedName definedName = new DefinedName(nameDefinition, this);
        this.definedNames.add(definedName);
    }

    public void addSettings(BookSettings bookSettings) throws IOException {
        int n = 0;
        Vector vector = bookSettings.getSheetSettings();
        String string = bookSettings.getActiveSheet();
        Enumeration enumeration = this.worksheets.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            Worksheet worksheet = (Worksheet)enumeration.nextElement();
            if (string.equals(string2 = this.getSheetName(n++))) {
                win1.setActiveSheet(n - 1);
            }
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                SheetSettings sheetSettings = (SheetSettings)enumeration2.nextElement();
                if (!string2.equals(sheetSettings.getSheetName())) continue;
                worksheet.addSettings(sheetSettings);
            }
        }
    }

    @Override
    public String getName() {
        int n = this.fileName.lastIndexOf(".");
        String string = n >= 0 ? this.fileName.substring(0, n) : this.fileName;
        return string;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }
}

