/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

class WikiProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLContext m_aSSLContext;

    public synchronized SSLContext GetNotSoSecureSSLContext() {
        if (this.m_aSSLContext == null) {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){
                private X509TrustManager m_aOrgTrustManager;

                private X509TrustManager GetOrgTrustManager() {
                    if (this.m_aOrgTrustManager == null) {
                        try {
                            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                            trustManagerFactory.init((KeyStore)null);
                            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                            if (trustManagerArray.length != 0 && trustManagerArray[0] != null) {
                                this.m_aOrgTrustManager = (X509TrustManager)trustManagerArray[0];
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("No access to the default trust manager!");
                        }
                    }
                    return this.m_aOrgTrustManager;
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return this.GetOrgTrustManager().getAcceptedIssuers();
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    this.GetOrgTrustManager().checkClientTrusted(x509CertificateArray, string);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                    if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                        this.GetOrgTrustManager().checkServerTrusted(x509CertificateArray, string);
                    } else {
                        for (int i = 0; i < x509CertificateArray.length; ++i) {
                            x509CertificateArray[i].checkValidity();
                        }
                    }
                }
            }};
            try {
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                if (sSLContext != null) {
                    sSLContext.init(null, trustManagerArray, null);
                    this.m_aSSLContext = sSLContext;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_aSSLContext == null) {
            throw new HttpClientError();
        }
        return this.m_aSSLContext;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            return this.createSocket(string, n, inetAddress, n2);
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        Socket socket = this.GetNotSoSecureSSLContext().getSocketFactory().createSocket();
        socket.bind(new InetSocketAddress(inetAddress, n2));
        socket.connect(new InetSocketAddress(string, n), n3);
        return socket;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(string, n);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return this.GetNotSoSecureSSLContext().getSocketFactory().createSocket(socket, string, n, bl);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(WikiProtocolSocketFactory.class);
    }

    public int hashCode() {
        return WikiProtocolSocketFactory.class.hashCode();
    }
}

