/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.impl.InvalidationListener;
import org.netbeans.modules.refactoring.spi.impl.UndoManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;

public class UndoWatcher {
    private static Collection extractCES(Collection elements) {
        HashSet<CloneableEditorSupport> result = new HashSet<CloneableEditorSupport>();
        for (RefactoringElement e : elements) {
            PositionBounds pb = e.getPosition();
            if (pb == null) continue;
            CloneableEditorSupport ces = pb.getBegin().getCloneableEditorSupport();
            result.add(ces);
        }
        return result;
    }

    public static void watch(RefactoringSession session, InvalidationListener l) {
        UndoManager.getDefault().watch(UndoWatcher.extractCES(session.getRefactoringElements()), l);
    }

    public static void stopWatching(InvalidationListener l) {
        UndoManager.getDefault().stopWatching(l);
    }

    public static void watch(DataObject o) {
        EditorCookie ces = (EditorCookie)o.getCookie(EditorCookie.class);
        assert (ces instanceof CloneableEditorSupport);
        UndoManager.getDefault().watch(Collections.singleton((CloneableEditorSupport)ces), null);
    }
}

