/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Scrollbar;
import java.awt.peer.ComponentPeer;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextPane;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.editors.AbstractFormatterFactoryEditor;
import org.netbeans.modules.form.editors.EnumEditor;
import org.netbeans.modules.form.editors.MnemonicEditor;
import org.netbeans.modules.form.editors.PrimitiveTypeArrayEditor;
import org.netbeans.modules.form.editors.SpinnerEditorEditor;
import org.netbeans.modules.form.editors2.JTableSelectionModelEditor;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class RADProperty
extends FormProperty {
    public static final String SYNTH_PREFIX = "$$$_";
    public static final String SYNTH_PRE_CODE = "$$$_preCode_";
    public static final String SYNTH_POST_CODE = "$$$_postCode_";
    private RADComponent component;
    private PropertyDescriptor desc;
    private Object defaultValue;

    public RADProperty(RADComponent metacomp, PropertyDescriptor propdesc) {
        super(new FormPropertyContext.Component(metacomp), propdesc.getName(), propdesc.getPropertyType(), propdesc.getDisplayName(), propdesc.getShortDescription());
        this.component = metacomp;
        this.desc = propdesc;
        if (this.desc.getWriteMethod() == null) {
            this.setAccessType(10);
        } else if (this.desc.getReadMethod() == null) {
            this.setAccessType(1);
        }
        this.defaultValue = BeanSupport.NO_VALUE;
        if (this.canReadFromTarget()) {
            try {
                this.defaultValue = this.getTargetValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public RADComponent getRADComponent() {
        return this.component;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.desc;
    }

    @Override
    public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
        Method readMethod = this.desc.getReadMethod();
        if (readMethod == null) {
            throw new IllegalAccessException("Not a readable property: " + this.desc.getName());
        }
        return readMethod.invoke(this.component.getBeanInstance(), new Object[0]);
    }

    @Override
    public void setTargetValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method writeMethod = this.desc.getWriteMethod();
        if (writeMethod == null) {
            throw new IllegalAccessException("Not a writeable property: " + this.desc.getName());
        }
        Object beanInstance = this.component.getBeanInstance();
        ComponentPeer scrollbarPeerHack = "setOrientation".equals(writeMethod.getName()) && beanInstance instanceof Scrollbar ? FakePeerSupport.detachFakePeer((Component)beanInstance) : null;
        try {
            writeMethod.invoke(this.component.getBeanInstance(), value);
        }
        catch (InvocationTargetException ex) {
            String message = FormUtils.getFormattedBundleString("MSG_ERR_WRITING_TO_PROPERTY", new Object[]{this.getDisplayName()});
            Throwable tex = ex.getTargetException();
            if (tex instanceof IllegalArgumentException) {
                ErrorManager.getDefault().annotate(tex, 16, null, message, null, null);
                if ("contentType".equals(this.getName()) && beanInstance instanceof JTextPane) {
                    return;
                }
                throw (IllegalArgumentException)tex;
            }
            if (tex instanceof IllegalAccessException) {
                ErrorManager.getDefault().annotate(tex, 16, null, message, null, null);
                throw (IllegalAccessException)tex;
            }
            if (value == null && tex instanceof NullPointerException) {
                IllegalArgumentException iae = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)iae, 16, null, message, null, null);
                throw iae;
            }
            ErrorManager.getDefault().annotate((Throwable)ex, 16, null, message, null, null);
            throw ex;
        }
        if (scrollbarPeerHack != null) {
            FakePeerSupport.attachFakePeer((Component)beanInstance, scrollbarPeerHack);
        }
    }

    @Override
    protected Object getRealValue(Object value) {
        Object realValue = super.getRealValue(value);
        if (realValue == FormDesignValue.IGNORED_VALUE) {
            Object instance = this.component.getBeanInstance();
            String propName = this.desc.getName();
            if (instance instanceof Component && "text".equals(propName)) {
                realValue = ((FormDesignValue)value).getDescription();
            } else if (!(!this.supportsDefaultValue() || instance instanceof JEditorPane && "page".equals(propName))) {
                return this.getDefaultValue();
            }
        }
        return realValue;
    }

    @Override
    public boolean supportsDefaultValue() {
        return this.defaultValue != BeanSupport.NO_VALUE;
    }

    @Override
    public Object getDefaultValue() {
        Object specialDefaultValue = FormUtils.getSpecialDefaultPropertyValue(this.component.getBeanInstance(), this.getName());
        return specialDefaultValue != BeanSupport.NO_VALUE ? specialDefaultValue : this.defaultValue;
    }

    @Override
    public boolean canWrite() {
        return this.component.isReadOnly() ? false : super.canWrite();
    }

    @Override
    public PropertyEditor getExpliciteEditor() {
        PropertyEditor prEd = null;
        PropertyDescriptor descriptor = this.getPropertyDescriptor();
        if (descriptor.getPropertyType() == Integer.TYPE && ("mnemonic".equals(descriptor.getName()) || "displayedMnemonic".equals(descriptor.getName()))) {
            prEd = new MnemonicEditor();
        } else if (descriptor.getPropertyType().isArray()) {
            String typeName = descriptor.getPropertyType().getSimpleName();
            if (typeName.equals("boolean[]") || typeName.equals("byte[]") || typeName.equals("short[]") || typeName.equals("int[]") || typeName.equals("long[]") || typeName.equals("float[]") || typeName.equals("double[]") || typeName.equals("char[]")) {
                prEd = new PrimitiveTypeArrayEditor();
            }
        } else {
            prEd = "editor".equals(descriptor.getName()) && JSpinner.class.isAssignableFrom(this.component.getBeanClass()) ? new SpinnerEditorEditor() : ("formatterFactory".equals(descriptor.getName()) && JFormattedTextField.class.isAssignableFrom(this.component.getBeanClass()) ? new AbstractFormatterFactoryEditor() : ("selectionModel".equals(descriptor.getName()) && JTable.class.equals(this.component.getBeanClass()) ? new JTableSelectionModelEditor() : this.createEnumEditor(descriptor)));
        }
        if (prEd == null) {
            try {
                prEd = this.desc.createPropertyEditor(this.component.getBeanInstance());
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        if (prEd == null && descriptor.getPropertyType().isEnum()) {
            prEd = RADProperty.createDefaultEnumEditor(descriptor.getPropertyType());
        }
        return prEd;
    }

    static PropertyEditor createDefaultEnumEditor(Class enumClass) {
        try {
            Method method = enumClass.getMethod("values", new Class[0]);
            Enum[] values = (Enum[])method.invoke(null, new Object[0]);
            ArrayList<Object> list = new ArrayList<Object>(3 * values.length);
            for (Enum value : values) {
                list.add(value.toString());
                list.add(value);
                list.add(enumClass.getName().replace('$', '.') + '.' + value.name());
            }
            list.add(NbBundle.getBundle(RADProperty.class).getString("CTL_NullText"));
            list.add(null);
            list.add("null");
            return new EnumEditor(list.toArray());
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    protected PropertyEditor createEnumEditor(PropertyDescriptor descriptor) {
        Object[] enumerationValues = !"debugGraphicsOptions".equals(descriptor.getName()) || !JComponent.class.isAssignableFrom(this.component.getBeanClass()) ? (Object[])descriptor.getValue("enumerationValues") : new Object[]{"NONE_OPTION", new Integer(-1), "DebugGraphics.NONE_OPTION", "NO_CHANGES", new Integer(0), "0", "LOG_OPTION", new Integer(1), "DebugGraphics.LOG_OPTION", "FLASH_OPTION", new Integer(2), "DebugGraphics.FLASH_OPTION", "BUFFERED_OPTION", new Integer(4), "DebugGraphics.BUFFERED_OPTION"};
        if (enumerationValues == null && "defaultCloseOperation".equals(descriptor.getName()) && (JDialog.class.isAssignableFrom(this.component.getBeanClass()) || JInternalFrame.class.isAssignableFrom(this.component.getBeanClass()))) {
            enumerationValues = new Object[]{"DISPOSE_ON_CLOSE", new Integer(2), "WindowConstants.DISPOSE_ON_CLOSE", "DO_NOTHING_ON_CLOSE", new Integer(0), "WindowConstants.DO_NOTHING_ON_CLOSE", "HIDE_ON_CLOSE", new Integer(1), "WindowConstants.HIDE_ON_CLOSE"};
        }
        return enumerationValues != null ? new EnumEditor(enumerationValues) : null;
    }

    @Override
    protected Method getWriteMethod() {
        return this.desc.getWriteMethod();
    }

    @Override
    public void setPreCode(String value) {
        if (this.preCode == null && value != null || this.preCode != null && !this.preCode.equals(value)) {
            String old = this.preCode;
            this.preCode = value;
            if (this.isChangeFiring() && this.component.getFormModel() != null) {
                this.component.getFormModel().fireSyntheticPropertyChanged(this.component, SYNTH_PRE_CODE + this.getName(), old, value);
            }
        }
    }

    @Override
    public void setPostCode(String value) {
        if (this.postCode == null && value != null || this.postCode != null && !this.postCode.equals(value)) {
            String old = this.postCode;
            this.postCode = value;
            if (this.isChangeFiring() && this.component.getFormModel() != null) {
                this.component.getFormModel().fireSyntheticPropertyChanged(this.component, SYNTH_POST_CODE + this.getName(), old, value);
            }
        }
    }

    static class FakePropertyDescriptor
    extends PropertyDescriptor {
        Class propType;

        FakePropertyDescriptor(String name, Class type) throws IntrospectionException {
            super(name, null, null);
            this.propType = type;
        }

        public Class getPropertyType() {
            return this.propType;
        }
    }
}

