/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.marshal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.marshal.UnmarshalStream;

public class UnmarshalCache {
    private final Ruby runtime;
    private final List<IRubyObject> links = new ArrayList<IRubyObject>();
    private final List<RubySymbol> symbols = new ArrayList<RubySymbol>();

    public UnmarshalCache(Ruby runtime) {
        this.runtime = runtime;
    }

    public void register(IRubyObject value) {
        this.selectCache(value).add(value);
    }

    private List selectCache(IRubyObject value) {
        return value instanceof RubySymbol ? this.symbols : this.links;
    }

    public boolean isLinkType(int c) {
        return c == 59 || c == 64;
    }

    public IRubyObject readLink(UnmarshalStream input, int type) throws IOException {
        int i = input.unmarshalInt();
        if (type == 64) {
            return this.linkedByIndex(i);
        }
        assert (type == 59);
        return this.symbolByIndex(i);
    }

    private IRubyObject linkedByIndex(int index) {
        try {
            return this.links.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.runtime.newArgumentError("dump format error (unlinked, index: " + index + ")");
        }
    }

    private RubySymbol symbolByIndex(int index) {
        try {
            return this.symbols.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.runtime.newTypeError("bad symbol");
        }
    }
}

