/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.structure.registry;

import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.structure.registry.RegistryScene;
import org.netbeans.modules.vmd.structure.registry.RegistryWidget;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RegistryEditorView
implements DataEditorView,
DescriptorRegistryListener {
    private static final long serialVersionUID = 3328221238376153199L;
    static final String REGISTRY_ID = "registry";
    private DataObjectContext context;
    private transient DescriptorRegistry registry;
    private transient JToolBar toolbarRepresentation;
    private transient JScrollPane scrollPane;
    private transient RegistryScene scene;
    private transient JComponent view;

    public RegistryEditorView() {
    }

    public RegistryEditorView(DataObjectContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        this.registry = DescriptorRegistry.getDescriptorRegistry((String)this.context.getProjectType(), (String)this.context.getProjectID());
        this.scene = new RegistryScene();
        this.view = this.scene.createView();
        this.scrollPane = new JScrollPane(this.view);
        this.toolbarRepresentation = new JToolBar();
        this.toolbarRepresentation.setFloatable(false);
    }

    public DataObjectContext getContext() {
        return this.context;
    }

    public DataEditorView.Kind getKind() {
        return DataEditorView.Kind.MODEL;
    }

    public boolean canShowSideWindows() {
        return true;
    }

    public Collection<String> getTags() {
        return Collections.emptySet();
    }

    public String preferredID() {
        return REGISTRY_ID;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RegistryEditorView.class, (String)"TITLE_RegistryView");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RegistryEditorView.class);
    }

    public JComponent getVisualRepresentation() {
        return this.scrollPane;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbarRepresentation;
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void componentOpened() {
        this.registry.addRegistryListener((DescriptorRegistryListener)this);
    }

    public void componentClosed() {
        this.registry.removeRegistryListener((DescriptorRegistryListener)this);
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public int getOpenPriority() {
        return this.getOrder();
    }

    public int getEditPriority() {
        return -this.getOrder();
    }

    public int getOrder() {
        return 12;
    }

    public void descriptorRegistryUpdated() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegistryEditorView.this.update();
            }
        });
    }

    private void update() {
        this.registry.readAccess(new Runnable(){

            @Override
            public void run() {
                RegistryWidget widget = new RegistryWidget((Scene)RegistryEditorView.this.scene, false, null, NbBundle.getMessage(RegistryEditorView.class, (String)"DISP_Descriptors"));
                Collection descriptors = RegistryEditorView.this.registry.getComponentDescriptors();
                RegistryEditorView.this.scene.clear();
                RegistryEditorView.this.scene.addRootNode("descriptors", widget);
                RegistryEditorView.this.updateForSuper(descriptors, null, widget);
                widget = new RegistryWidget((Scene)RegistryEditorView.this.scene, false, null, NbBundle.getMessage(RegistryEditorView.class, (String)"DISP_Producers"));
                RegistryEditorView.this.scene.addRootNode("producers", widget);
                for (ComponentProducer producer : RegistryEditorView.this.registry.getComponentProducers()) {
                    RegistryWidget sub;
                    PaletteDescriptor paletteDescriptor = producer.getPaletteDescriptor();
                    if (paletteDescriptor != null) {
                        String smallIcon = paletteDescriptor.getSmallIcon();
                        Image image = smallIcon != null ? ImageUtilities.loadImage((String)smallIcon) : null;
                        sub = new RegistryWidget((Scene)RegistryEditorView.this.scene, true, image, paletteDescriptor.getDisplayName());
                    } else {
                        sub = new RegistryWidget((Scene)RegistryEditorView.this.scene, false, null, producer.getMainComponentTypeID().toString());
                    }
                    widget.addSub("producer:" + producer.getProducerID(), sub);
                }
                RegistryEditorView.this.scene.validate();
            }
        });
    }

    private void updateForSuper(Collection<ComponentDescriptor> descriptors, ComponentDescriptor superDescriptor, RegistryWidget widget) {
        for (ComponentDescriptor componentDescriptor : descriptors) {
            RegistryWidget sub;
            if (componentDescriptor.getSuperDescriptor() != superDescriptor) continue;
            PaletteDescriptor paletteDescriptor = componentDescriptor.getPaletteDescriptor();
            if (paletteDescriptor != null) {
                String smallIcon = paletteDescriptor.getSmallIcon();
                Image image = smallIcon != null ? ImageUtilities.loadImage((String)smallIcon) : null;
                sub = new RegistryWidget((Scene)this.scene, true, image, paletteDescriptor.getDisplayName());
            } else {
                sub = new RegistryWidget((Scene)this.scene, false, null, componentDescriptor.getTypeDescriptor().getThisType().toString());
            }
            widget.addSub("descriptor:" + componentDescriptor.getTypeDescriptor().getThisType(), sub);
            this.updateForSuper(descriptors, componentDescriptor, sub);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.context);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        this.init();
    }
}

