/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBaseForm;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class STSIssuedSupportingToken
extends ProfileBaseForm {
    private int suppTokenTypeUsed = 5;
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JCheckBox derivedKeysChBox;
    private JCheckBox encryptOrderChBox;
    private JCheckBox encryptSignatureChBox;
    private JTextField issuerAddressField;
    private JLabel issuerAddressLabel;
    private JTextField issuerMetadataField;
    private JLabel issuerMetadataLabel;
    private JComboBox keySizeCombo;
    private JLabel keySizeLabel;
    private JComboBox keyTypeCombo;
    private JLabel keyTypeLabel;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox reqDerivedKeys;
    private JCheckBox reqDerivedKeysIssued;
    private JCheckBox reqSigConfChBox;
    private JCheckBox secConvChBox;
    private JComboBox tokenTypeCombo;
    private JLabel tokenTypeLabel;

    public STSIssuedSupportingToken(WSDLComponent comp, SecurityProfile secProfile) {
        super(comp, secProfile);
        this.initComponents();
        this.inSync = true;
        this.fillLayoutCombo(this.layoutCombo);
        this.tokenTypeCombo.removeAllItems();
        this.tokenTypeCombo.addItem(ComboConstants.ISSUED_TOKENTYPE_SAML10);
        this.tokenTypeCombo.addItem(ComboConstants.ISSUED_TOKENTYPE_SAML11);
        this.tokenTypeCombo.addItem(ComboConstants.ISSUED_TOKENTYPE_SAML20);
        this.keyTypeCombo.removeAllItems();
        this.keyTypeCombo.addItem(ComboConstants.ISSUED_KEYTYPE_SYMMETRIC);
        this.keyTypeCombo.addItem(ComboConstants.ISSUED_KEYTYPE_PUBLIC);
        this.keyTypeCombo.addItem(ComboConstants.ISSUED_KEYTYPE_NOPROOF);
        this.fillKeySize(this.keySizeCombo);
        this.fillAlgoSuiteCombo(this.algoSuiteCombo);
        this.inSync = false;
        if (ConfigVersion.CONFIG_1_0 == this.cfgVersion) {
            this.suppTokenTypeUsed = 1;
        }
        this.sync();
    }

    @Override
    protected void sync() {
        this.inSync = true;
        ExtensibilityElement secBinding = null;
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        boolean secConv = protToken instanceof SecureConversationToken;
        this.setChBox(this.secConvChBox, secConv);
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(protToken, BootstrapPolicy.class);
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            Policy p = (Policy)secBinding.getParent();
            this.setChBox(this.derivedKeysChBox, SecurityPolicyModelHelper.isRequireDerivedKeys(protToken));
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation((WSDLComponent)p));
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(bootPolicy));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(bootPolicy));
        } else {
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            this.setChBox(this.derivedKeysChBox, false);
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation(this.comp));
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(this.comp));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(this.comp));
        }
        WSDLComponent tokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)secBinding, ProtectionToken.class);
        WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
        this.setChBox(this.reqDerivedKeys, SecurityPolicyModelHelper.isRequireDerivedKeys(token));
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)secBinding));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout((WSDLComponent)secBinding));
        tokenKind = secConv ? SecurityTokensModelHelper.getSupportingToken((WSDLComponent)secBinding.getParent(), this.suppTokenTypeUsed) : SecurityTokensModelHelper.getSupportingToken(this.comp, this.suppTokenTypeUsed);
        token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
        this.setChBox(this.reqDerivedKeysIssued, SecurityPolicyModelHelper.isRequireDerivedKeys(token));
        this.setCombo(this.tokenTypeCombo, SecurityTokensModelHelper.getIssuedTokenType(token));
        this.setCombo(this.keyTypeCombo, SecurityTokensModelHelper.getIssuedKeyType(token));
        this.setCombo(this.keySizeCombo, SecurityTokensModelHelper.getIssuedKeySize(token));
        this.issuerAddressField.setText(SecurityTokensModelHelper.getIssuedIssuerAddress(token));
        this.issuerMetadataField.setText(SecurityTokensModelHelper.getIssuedIssuerMetadataAddress(token));
        this.enableDisable();
        this.inSync = false;
    }

    @Override
    public void setValue(JComponent source) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement secBinding = null;
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        boolean secConv = protToken instanceof SecureConversationToken;
        if (source.equals(this.secConvChBox)) {
            ((SecureConversationFeature)((Object)this.secProfile)).enableSecureConversation(this.comp, this.secConvChBox.isSelected());
            this.sync();
        }
        SecurityPolicyModelHelper spmh = SecurityPolicyModelHelper.getInstance(this.cfgVersion);
        SecurityTokensModelHelper stmh = SecurityTokensModelHelper.getInstance(this.cfgVersion);
        AlgoSuiteModelHelper asmh = AlgoSuiteModelHelper.getInstance(this.cfgVersion);
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(protToken, BootstrapPolicy.class);
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            Policy p = (Policy)secBinding.getParent();
            if (source.equals(this.derivedKeysChBox)) {
                spmh.enableRequireDerivedKeys(protToken, this.derivedKeysChBox.isSelected());
            }
            if (source.equals(this.reqSigConfChBox)) {
                spmh.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11((WSDLComponent)p), this.reqSigConfChBox.isSelected());
            }
        } else {
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            if (source.equals(this.reqSigConfChBox)) {
                spmh.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
            }
        }
        WSDLComponent tokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)secBinding, ProtectionToken.class);
        WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
        if (source.equals(this.encryptSignatureChBox)) {
            spmh.enableEncryptSignature((WSDLComponent)secBinding, this.encryptSignatureChBox.isSelected());
            if (secConv) {
                spmh.enableEncryptSignature((WSDLComponent)topSecBinding, this.encryptSignatureChBox.isSelected());
            }
        }
        if (source.equals(this.encryptOrderChBox)) {
            spmh.enableEncryptBeforeSigning((WSDLComponent)secBinding, this.encryptOrderChBox.isSelected());
            if (secConv) {
                spmh.enableEncryptBeforeSigning((WSDLComponent)topSecBinding, this.encryptOrderChBox.isSelected());
            }
        }
        if (source.equals(this.layoutCombo)) {
            spmh.setLayout((WSDLComponent)secBinding, (String)this.layoutCombo.getSelectedItem());
            if (secConv) {
                spmh.setLayout((WSDLComponent)topSecBinding, (String)this.layoutCombo.getSelectedItem());
            }
        }
        if (source.equals(this.algoSuiteCombo)) {
            asmh.setAlgorithmSuite((WSDLComponent)secBinding, (String)this.algoSuiteCombo.getSelectedItem());
            if (secConv) {
                asmh.setAlgorithmSuite((WSDLComponent)topSecBinding, (String)this.algoSuiteCombo.getSelectedItem());
            }
        }
        if (source.equals(this.reqDerivedKeys)) {
            spmh.enableRequireDerivedKeys(token, this.reqDerivedKeys.isSelected());
            return;
        }
        tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)secBinding.getParent(), this.suppTokenTypeUsed);
        token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
        if (source.equals(this.reqDerivedKeysIssued)) {
            spmh.enableRequireDerivedKeys(token, this.reqDerivedKeysIssued.isSelected());
            return;
        }
        if (source.equals(this.tokenTypeCombo) || source.equals(this.keyTypeCombo) || source.equals(this.keySizeCombo)) {
            if (ComboConstants.ISSUED_KEYTYPE_NOPROOF.equals(this.keyTypeCombo.getSelectedItem())) {
                stmh.setIssuedTokenRSTAttributes(token, (String)this.tokenTypeCombo.getSelectedItem(), (String)this.keyTypeCombo.getSelectedItem(), null);
            } else {
                stmh.setIssuedTokenRSTAttributes(token, (String)this.tokenTypeCombo.getSelectedItem(), (String)this.keyTypeCombo.getSelectedItem(), (String)this.keySizeCombo.getSelectedItem());
            }
        }
        if (source.equals(this.issuerAddressField) || source.equals(this.issuerMetadataField)) {
            stmh.setIssuedTokenAddressAttributes(token, this.issuerAddressField.getText(), this.issuerMetadataField.getText());
        }
        this.enableDisable();
    }

    @Override
    protected void enableDisable() {
        boolean secConvEnabled = this.secConvChBox.isSelected();
        this.derivedKeysChBox.setEnabled(secConvEnabled);
        boolean keySizeNeeded = true;
        if (ComboConstants.ISSUED_KEYTYPE_NOPROOF.equals(this.keyTypeCombo.getSelectedItem())) {
            keySizeNeeded = false;
        }
        this.keySizeCombo.setEnabled(keySizeNeeded);
        this.keySizeLabel.setEnabled(keySizeNeeded);
    }

    private void initComponents() {
        this.secConvChBox = new JCheckBox();
        this.reqSigConfChBox = new JCheckBox();
        this.derivedKeysChBox = new JCheckBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.encryptSignatureChBox = new JCheckBox();
        this.reqDerivedKeysIssued = new JCheckBox();
        this.encryptOrderChBox = new JCheckBox();
        this.issuerAddressLabel = new JLabel();
        this.issuerAddressField = new JTextField();
        this.issuerMetadataLabel = new JLabel();
        this.issuerMetadataField = new JTextField();
        this.tokenTypeLabel = new JLabel();
        this.keyTypeLabel = new JLabel();
        this.keySizeLabel = new JLabel();
        this.tokenTypeCombo = new JComboBox();
        this.keyTypeCombo = new JComboBox();
        this.keySizeCombo = new JComboBox();
        this.reqDerivedKeys = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.secConvChBox, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_SecConvLabel"));
        this.secConvChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.secConvChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.secConvChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqSigConfChBox, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_RequireSigConfirmation"));
        this.reqSigConfChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqSigConfChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqSigConfChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.reqSigConfChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.derivedKeysChBox, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_RequireDerivedKeysForSecConv"));
        this.derivedKeysChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.derivedKeysChBox.setMargin(new Insets(0, 0, 0, 0));
        this.derivedKeysChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.derivedKeysChBoxActionPerformed(evt);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.algoSuiteComboActionPerformed(evt);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.layoutComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptSignatureChBox, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_EncryptSignatureLabel"));
        this.encryptSignatureChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptSignatureChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptSignatureChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.encryptSignatureChBox(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqDerivedKeysIssued, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_RequireDerivedKeysIssued"));
        this.reqDerivedKeysIssued.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqDerivedKeysIssued.setMargin(new Insets(0, 0, 0, 0));
        this.reqDerivedKeysIssued.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.reqDerivedKeysIssuedActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptOrderChBox, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_EncryptOrderLabel"));
        this.encryptOrderChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptOrderChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptOrderChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.encryptOrderChBoxActionPerformed(evt);
            }
        });
        this.issuerAddressLabel.setLabelFor(this.issuerAddressField);
        Mnemonics.setLocalizedText((JLabel)this.issuerAddressLabel, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_IssuerAddress"));
        this.issuerAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                STSIssuedSupportingToken.this.issuerAddressFieldKeyReleased(evt);
            }
        });
        this.issuerMetadataLabel.setLabelFor(this.issuerMetadataField);
        Mnemonics.setLocalizedText((JLabel)this.issuerMetadataLabel, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_IssuerMetadataAddress"));
        this.issuerMetadataField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                STSIssuedSupportingToken.this.issuerMetadataFieldKeyReleased(evt);
            }
        });
        this.tokenTypeLabel.setLabelFor(this.tokenTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.tokenTypeLabel, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_RSTTokenType"));
        this.keyTypeLabel.setLabelFor(this.keyTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.keyTypeLabel, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_RSTKeyType"));
        this.keySizeLabel.setLabelFor(this.keySizeCombo);
        Mnemonics.setLocalizedText((JLabel)this.keySizeLabel, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_RSTKeySize"));
        this.tokenTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.tokenTypeComboActionPerformed(evt);
            }
        });
        this.keyTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.keyTypeComboActionPerformed(evt);
            }
        });
        this.keySizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.keySizeComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqDerivedKeys, (String)NbBundle.getMessage(STSIssuedSupportingToken.class, (String)"LBL_RequireDerivedKeysX509"));
        this.reqDerivedKeys.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqDerivedKeys.setMargin(new Insets(0, 0, 0, 0));
        this.reqDerivedKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STSIssuedSupportingToken.this.reqDerivedKeysActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.reqSigConfChBox).add((Component)this.secConvChBox).add((Component)this.derivedKeysChBox).add((Component)this.encryptSignatureChBox).add((Component)this.encryptOrderChBox).add((Component)this.reqDerivedKeys).add((Component)this.reqDerivedKeysIssued).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.issuerMetadataLabel).add((Component)this.layoutLabel).add((Component)this.algoSuiteLabel).add((Component)this.tokenTypeLabel).add((Component)this.keyTypeLabel).add((Component)this.keySizeLabel).add((Component)this.issuerAddressLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.tokenTypeCombo, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.keySizeCombo, -2, -1, -2).add((Component)this.keyTypeCombo, -2, -1, -2))).add((Component)this.algoSuiteCombo, -2, -1, -2).add((Component)this.layoutCombo, -2, -1, -2).add((Component)this.issuerMetadataField, -1, 159, Short.MAX_VALUE).add((Component)this.issuerAddressField)))).addContainerGap(12, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.algoSuiteCombo, this.keySizeCombo, this.keyTypeCombo, this.layoutCombo, this.tokenTypeCombo}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.issuerAddressLabel).add((Component)this.issuerAddressField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.issuerMetadataLabel).add((Component)this.issuerMetadataField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.tokenTypeLabel).add((Component)this.tokenTypeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.keyTypeLabel).add((Component)this.keyTypeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.keySizeLabel).add((Component)this.keySizeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.algoSuiteLabel).add((Component)this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.layoutLabel).add((Component)this.layoutCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.reqDerivedKeys).addPreferredGap(0).add((Component)this.reqDerivedKeysIssued).addPreferredGap(0).add((Component)this.secConvChBox).addPreferredGap(0).add((Component)this.derivedKeysChBox).addPreferredGap(0).add((Component)this.reqSigConfChBox).addPreferredGap(0).add((Component)this.encryptSignatureChBox).addPreferredGap(0).add((Component)this.encryptOrderChBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.algoSuiteCombo, this.keySizeCombo, this.keyTypeCombo, this.layoutCombo, this.tokenTypeCombo}, 2);
    }

    private void reqDerivedKeysActionPerformed(ActionEvent evt) {
        this.setValue(this.reqDerivedKeys);
    }

    private void keySizeComboActionPerformed(ActionEvent evt) {
        this.setValue(this.keySizeCombo);
    }

    private void keyTypeComboActionPerformed(ActionEvent evt) {
        this.setValue(this.keyTypeCombo);
    }

    private void tokenTypeComboActionPerformed(ActionEvent evt) {
        this.setValue(this.tokenTypeCombo);
    }

    private void issuerMetadataFieldKeyReleased(KeyEvent evt) {
        this.setValue(this.issuerMetadataField);
    }

    private void issuerAddressFieldKeyReleased(KeyEvent evt) {
        this.setValue(this.issuerAddressField);
    }

    private void encryptOrderChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.encryptOrderChBox);
    }

    private void reqDerivedKeysIssuedActionPerformed(ActionEvent evt) {
        this.setValue(this.reqDerivedKeysIssued);
    }

    private void reqSigConfChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.reqSigConfChBox);
    }

    private void derivedKeysChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.derivedKeysChBox);
    }

    private void secConvChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.secConvChBox);
    }

    private void encryptSignatureChBox(ActionEvent evt) {
        this.setValue(this.encryptSignatureChBox);
    }

    private void layoutComboActionPerformed(ActionEvent evt) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent evt) {
        this.setValue(this.algoSuiteCombo);
    }
}

