/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class SourceGroupSupport {
    private SourceGroupSupport() {
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set set = SourceGroupSupport.getTestSourceGroups(sourceGroupArray);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (set.contains(sourceGroupArray[i])) continue;
            arrayList.add(sourceGroupArray[i]);
        }
        return arrayList.toArray(new SourceGroup[arrayList.size()]);
    }

    public static boolean isValidPackageName(String string) {
        if (string.length() > 0 && string.charAt(0) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFolderWritable(SourceGroup sourceGroup, String string) {
        try {
            FileObject fileObject = SourceGroupSupport.getFolderForPackage(sourceGroup, string, false);
            while (fileObject == null && string.lastIndexOf(46) != -1) {
                string = string.substring(0, string.lastIndexOf(46));
                fileObject = SourceGroupSupport.getFolderForPackage(sourceGroup, string, false);
            }
            return fileObject == null || fileObject.canWrite();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static SourceGroup findSourceGroupForFile(Project project, FileObject fileObject) {
        return SourceGroupSupport.findSourceGroupForFile(SourceGroupSupport.getJavaSourceGroups(project), fileObject);
    }

    public static SourceGroup findSourceGroupForFile(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject) && !sourceGroupArray[i].getRootFolder().equals(fileObject)) continue;
            return sourceGroupArray[i];
        }
        return null;
    }

    public static String getPackageForFolder(SourceGroup sourceGroup, FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
        if (string != null) {
            return string.replace('/', '.');
        }
        return "";
    }

    public static String packageForFolder(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        SourceGroup sourceGroup = SourceGroupSupport.findSourceGroupForFile(sourceGroupArray, fileObject);
        if (sourceGroup != null) {
            return SourceGroupSupport.getPackageForFolder(sourceGroup, fileObject);
        }
        return "";
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String string) throws IOException {
        return SourceGroupSupport.getFolderForPackage(sourceGroup, string, false);
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String string, boolean bl) throws IOException {
        if (sourceGroup == null || string == null) {
            return null;
        }
        String string2 = string.replace('.', '/');
        FileObject fileObject = sourceGroup.getRootFolder().getFileObject(string2);
        if (fileObject != null) {
            return fileObject;
        }
        if (bl) {
            return FileUtil.createFolder((FileObject)sourceGroup.getRootFolder(), (String)string2);
        }
        return null;
    }

    private static Map createFoldersToSourceGroupsMap(SourceGroup[] sourceGroupArray) {
        HashMap<FileObject, SourceGroup> hashMap;
        if (sourceGroupArray.length == 0) {
            hashMap = Collections.EMPTY_MAP;
        } else {
            hashMap = new HashMap<FileObject, SourceGroup>(2 * sourceGroupArray.length, 0.5f);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                hashMap.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return hashMap;
    }

    private static Set getTestSourceGroups(SourceGroup[] sourceGroupArray) {
        Map map = SourceGroupSupport.createFoldersToSourceGroupsMap(sourceGroupArray);
        HashSet hashSet = new HashSet();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            hashSet.addAll(SourceGroupSupport.getTestTargets(sourceGroupArray[i], map));
        }
        return hashSet;
    }

    private static List getTestTargets(SourceGroup sourceGroup, Map map) {
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (uRLArray.length == 0) {
            return new ArrayList();
        }
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        List list = SourceGroupSupport.getFileObjects(uRLArray, true);
        for (int i = 0; i < list.size(); ++i) {
            FileObject fileObject = (FileObject)list.get(i);
            SourceGroup sourceGroup2 = (SourceGroup)map.get(fileObject);
            if (sourceGroup2 == null) continue;
            arrayList.add(sourceGroup2);
        }
        return arrayList;
    }

    private static List getFileObjects(URL[] uRLArray, boolean bl) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < uRLArray.length; ++i) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObject != null) {
                arrayList.add(fileObject);
                continue;
            }
            if (bl) continue;
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + uRLArray[i]));
        }
        return arrayList;
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(0, n) : null;
    }

    public static String getClassName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static JavaSource getJavaSourceFromClassName(String string, Project project) throws IOException {
        FileObject fileObject = SourceGroupSupport.getFileObjectFromClassName(string, project);
        if (fileObject != null) {
            return JavaSource.forFileObject((FileObject)fileObject);
        }
        return null;
    }

    public static FileObject getFileObjectFromClassName(String string, Project project) throws IOException {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        FileObject fileObject = restSupport.findSourceRoot();
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fileObject);
        ClassIndex classIndex = classpathInfo.getClassIndex();
        int n = string.lastIndexOf(46) + 1;
        String string2 = string.substring(n);
        Set set = classIndex.getDeclaredTypes(string2, ClassIndex.NameKind.SIMPLE_NAME, Collections.singleton(ClassIndex.SearchScope.SOURCE));
        for (ElementHandle elementHandle : set) {
            if (!string.equals(elementHandle.getQualifiedName())) continue;
            return SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)classpathInfo);
        }
        return null;
    }

    public static FileObject findJavaSourceFile(Project project, String string) {
        for (SourceGroup sourceGroup : SourceGroupSupport.getJavaSourceGroups(project)) {
            Enumeration enumeration = sourceGroup.getRootFolder().getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject = (FileObject)enumeration.nextElement();
                if (!"java".equals(fileObject.getExt()) || !string.equals(fileObject.getName())) continue;
                return fileObject;
            }
        }
        return null;
    }

    public static List<ClassPath> gerClassPath(Project project) {
        ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>();
        ArrayList<SourceGroup> arrayList2 = new ArrayList<SourceGroup>();
        arrayList2.addAll(Arrays.asList(ProjectUtils.getSources((Project)project).getSourceGroups("java")));
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        for (SourceGroup sourceGroup : arrayList2) {
            ClassPath classPath = classPathProvider.findClassPath(sourceGroup.getRootFolder(), "classpath/compile");
            if (classPath != null) {
                arrayList.add(classPath);
            }
            if ((classPath = classPathProvider.findClassPath(sourceGroup.getRootFolder(), "classpath/source")) == null) continue;
            arrayList.add(classPath);
        }
        return arrayList;
    }
}

