/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

public class GdbVersionPeculiarity {
    private final double version;
    private final int platform;
    private static final boolean DISABLE_PENDING = Boolean.getBoolean("gdb.breakpoints.pending.disabled");

    private GdbVersionPeculiarity(double version, int platform) {
        this.version = version;
        this.platform = platform;
    }

    public static GdbVersionPeculiarity create(double version, int platform) {
        return new GdbVersionPeculiarity(version, platform);
    }

    public String environmentDirectoryCommand() {
        if (this.version > 6.3 || this.platform == 4) {
            return "-environment-directory";
        }
        return "directory";
    }

    public String environmentCdCommand() {
        if (this.version > 6.3) {
            return "-environment-cd";
        }
        return "cd";
    }

    public String execAbortCommand() {
        if (this.version > 6.6) {
            return "-exec-abort";
        }
        return "kill";
    }

    public String breakPendingFlag() {
        if (!DISABLE_PENDING && (this.version >= 6.8 || this.platform == 4)) {
            return "-f ";
        }
        return "";
    }

    public boolean isSupported() {
        return this.version >= 6.6 || this.platform == 4 && this.version >= 6.3;
    }
}

