/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.IOException;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.core.startup.preferences.PropertiesStorage;
import org.openide.ErrorManager;
import org.openide.util.EditableProperties;
import org.openide.util.RequestProcessor;

public abstract class NbPreferences
extends AbstractPreferences {
    private static Preferences USER_ROOT;
    private static Preferences SYSTEM_ROOT;
    EditableProperties properties;
    FileStorage fileStorage;
    private static final RequestProcessor RP;
    final RequestProcessor.Task flushTask = RP.create(new Runnable(){

        @Override
        public void run() {
            NbPreferences.this.fileStorage.runAtomic(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = NbPreferences.this.lock;
                    synchronized (object) {
                        try {
                            NbPreferences.this.flushSpi();
                        }
                        catch (BackingStoreException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                }
            });
        }
    }, true);

    static Preferences userRootImpl() {
        if (USER_ROOT == null) {
            USER_ROOT = new UserPreferences();
        }
        assert (USER_ROOT != null);
        return USER_ROOT;
    }

    static Preferences systemRootImpl() {
        if (SYSTEM_ROOT == null) {
            SYSTEM_ROOT = new SystemPreferences();
        }
        assert (SYSTEM_ROOT != null);
        return SYSTEM_ROOT;
    }

    private NbPreferences(boolean user) {
        super(null, "");
        this.fileStorage = this.getFileStorage(this.absolutePath());
    }

    private NbPreferences(NbPreferences parent, String name) {
        super(parent, name);
        this.fileStorage = this.getFileStorage(this.absolutePath());
        this.newNode = !this.fileStorage.existsNode();
    }

    @Override
    protected final String getSpi(String key) {
        return this.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.properties().getProperty(key);
        }
    }

    @Override
    protected final String[] childrenNamesSpi() throws BackingStoreException {
        return this.fileStorage.childrenNames();
    }

    @Override
    protected final String[] keysSpi() throws BackingStoreException {
        return this.getKeysSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeysSpi() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            return this.properties().keySet().toArray(new String[0]);
        }
    }

    @Override
    protected final void putSpi(String key, String value) {
        this.putProperty(key, value);
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putProperty(String key, String value) {
        Object object = this.lock;
        synchronized (object) {
            this.properties().put(key, value);
        }
    }

    @Override
    public void put(String key, String value) {
        String oldValue = this.getSpi(key);
        if (value.equals(oldValue)) {
            return;
        }
        try {
            super.put(key, value);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().contains("too long")) {
                this.putSpi(key, value);
            }
            throw iae;
        }
    }

    @Override
    protected final void removeSpi(String key) {
        this.removeProperty(key);
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProperty(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.properties().remove((Object)key);
        }
    }

    @Override
    protected final void removeNodeSpi() throws BackingStoreException {
        try {
            this.fileStorage.removeNode();
        }
        catch (IOException ex) {
            throw new BackingStoreException(ex);
        }
    }

    private void asyncInvocationOfFlushSpi() {
        if (!this.fileStorage.isReadOnly()) {
            this.flushTask.schedule(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.fileStorage.save(this.properties());
            }
        }
        catch (IOException ex) {
            throw new BackingStoreException(ex);
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.properties != null) {
            try {
                this.putAllProperties(this.fileStorage.load(), true);
            }
            catch (IOException ex) {
                throw new BackingStoreException(ex);
            }
        }
    }

    private EditableProperties properties() {
        if (this.properties == null) {
            this.properties = new EditableProperties(true);
            try {
                this.putAllProperties(this.fileStorage.load(), false);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAllProperties(EditableProperties props, boolean clear) {
        Object object = this.lock;
        synchronized (object) {
            if (clear) {
                this.properties().clear();
            }
            this.properties().putAll((Map)props);
        }
    }

    @Override
    public final void removeNode() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        this.clearProperties();
        super.removeNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProperties() {
        Object object = this.lock;
        synchronized (object) {
            this.properties().clear();
        }
    }

    @Override
    public final void flush() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        super.flush();
    }

    @Override
    public final void sync() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        this.flushTask.waitFinished();
        super.sync();
    }

    protected abstract FileStorage getFileStorage(String var1);

    static {
        RP = new RequestProcessor();
    }

    static interface FileStorage {
        public boolean isReadOnly();

        public String[] childrenNames();

        public boolean existsNode();

        public void removeNode() throws IOException;

        public void markModified();

        public EditableProperties load() throws IOException;

        public void save(EditableProperties var1) throws IOException;

        public void runAtomic(Runnable var1);
    }

    private static final class SystemPreferences
    extends NbPreferences {
        private SystemPreferences() {
            super(false);
        }

        private SystemPreferences(NbPreferences parent, String name) {
            super(parent, name);
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            return new SystemPreferences(this, name);
        }

        @Override
        protected FileStorage getFileStorage(String absolutePath) {
            return PropertiesStorage.instanceReadOnly(this.absolutePath());
        }
    }

    public static class UserPreferences
    extends NbPreferences {
        public UserPreferences() {
            super(true);
        }

        private UserPreferences(NbPreferences parent, String name) {
            super(parent, name);
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            return new UserPreferences(this, name);
        }

        @Override
        protected FileStorage getFileStorage(String absolutePath) {
            return PropertiesStorage.instance(this.absolutePath());
        }
    }
}

