/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlRetriever
implements Runnable {
    public static final int STATUS_START = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_DOWNLOADING = 2;
    public static final int STATUS_COMPLETE = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_TERMINATED = 5;
    public static final int STATUS_BAD_WSDL = 6;
    static final String[] STATUS_MESSAGE = new String[]{NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Ready"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Connecting"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Downloading"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Complete"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Exception"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_Terminated"), NbBundle.getMessage(WsdlRetriever.class, (String)"LBL_UnknownFileType")};
    private volatile boolean shutdown = false;
    private volatile int status = 0;
    private String wsdlUrlName;
    private byte[] wsdlContent;
    private List<SchemaInfo> schemas;
    private String wsdlFileName;
    private MessageReceiver receiver;
    private URL wsdlUrl;
    private URLConnection connection;
    private InputStream in;

    public WsdlRetriever(MessageReceiver r, String url) {
        this.wsdlUrlName = url;
        this.wsdlContent = null;
        this.wsdlFileName = null;
        this.schemas = null;
        this.receiver = r;
    }

    public byte[] getWsdl() {
        return this.wsdlContent;
    }

    public List<SchemaInfo> getSchemas() {
        return this.schemas;
    }

    public int getState() {
        return this.status;
    }

    public String getWsdlFileName() {
        return this.wsdlFileName;
    }

    public String getWsdlUrl() {
        return this.wsdlUrlName;
    }

    public synchronized void stopRetrieval() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.wsdlUrl = null;
        this.connection = null;
        this.in = null;
        try {
            this.wsdlUrlName = WsdlRetriever.beautifyUrlName(this.wsdlUrlName);
            this.wsdlUrl = new URL(this.wsdlUrlName);
            this.setState(1);
            if (this.wsdlUrlName.startsWith("https")) {
                this.setRetrieverTrustManager();
            }
            this.connection = this.wsdlUrl.openConnection();
            this.in = this.connection.getInputStream();
            this.setState(2);
            this.wsdlContent = this.downloadWsdlFileEncoded(new BufferedInputStream(this.in));
            WsdlInfo wsdlInfo = null;
            if (!this.shutdown) {
                wsdlInfo = this.getWsdlInfo();
                if (wsdlInfo != null) {
                    List<String> schemaNames = wsdlInfo.getSchemaNames();
                    if (!schemaNames.isEmpty()) {
                        this.schemas = new ArrayList<SchemaInfo>();
                        Iterator<String> it = schemaNames.iterator();
                        while (!this.shutdown && it.hasNext()) {
                            String schemaName = it.next();
                            String schemaUrlName = this.getSchemaUrlName(this.wsdlUrlName, schemaName);
                            URL schemaUrl = new URL(schemaUrlName);
                            this.connection = schemaUrl.openConnection();
                            this.in = this.connection.getInputStream();
                            this.schemas.add(new SchemaInfo(schemaName, this.downloadWsdlFileEncoded(new BufferedInputStream(this.in))));
                        }
                    }
                } else {
                    throw new MalformedURLException();
                }
            }
            if (!this.shutdown) {
                List<String> serviceNames = wsdlInfo.getServiceNameList();
                if (serviceNames != null && serviceNames.size() > 0) {
                    this.wsdlFileName = this.wsdlUrl.getPath();
                    int slashIndex = this.wsdlFileName.lastIndexOf(47);
                    if (slashIndex != -1) {
                        this.wsdlFileName = this.wsdlFileName.substring(slashIndex + 1);
                    }
                    if (this.wsdlFileName.length() == 0) {
                        this.wsdlFileName = serviceNames.get(0) + ".wsdl";
                    } else if (this.wsdlFileName.length() < 5 || !".wsdl".equals(this.wsdlFileName.substring(this.wsdlFileName.length() - 5))) {
                        this.wsdlFileName = this.wsdlFileName + ".wsdl";
                    }
                    this.setState(3);
                } else {
                    this.setState(6);
                }
            } else {
                this.setState(5);
            }
        }
        catch (ConnectException ex) {
            this.setState(4, NbBundle.getMessage(WsdlRetriever.class, (String)"ERR_Connection"), ex);
            this.log(ex.getMessage());
        }
        catch (MalformedURLException ex) {
            this.setState(4, NbBundle.getMessage(WsdlRetriever.class, (String)"ERR_BadUrl"), ex);
            this.log(ex.getMessage());
        }
        catch (IOException ex) {
            this.setState(4, NbBundle.getMessage(WsdlRetriever.class, (String)"ERR_IOException"), ex);
            this.log(ex.getMessage());
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private byte[] downloadWsdlFileEncoded(InputStream in) throws IOException {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int BUF = 65536;
        boolean eof = false;
        byte[] data = new byte[]{};
        while (!this.shutdown && !eof) {
            byte[] b = new byte[65536];
            int i = 0;
            int l = 0;
            int limit = b.length;
            int chunksize = 0;
            while (!this.shutdown && (l = in.read(b, i, limit)) != -1) {
                i += l;
                chunksize += l;
                if ((limit -= l) != 0) continue;
            }
            if (chunksize > 0) {
                chunks.add(new Chunk(b, chunksize));
            }
            eof = l == -1;
        }
        if (!this.shutdown) {
            int bufLen = 0;
            Iterator iter = chunks.iterator();
            while (iter.hasNext()) {
                bufLen += ((Chunk)iter.next()).getLength();
            }
            data = new byte[bufLen];
            int index = 0;
            for (Chunk c : chunks) {
                System.arraycopy(c.getData(), 0, data, index, c.getLength());
                index += c.getLength();
            }
        }
        return data;
    }

    public static String beautifyUrlName(String urlName) {
        if (urlName.indexOf("://") == -1) {
            return "http://" + urlName;
        }
        return urlName;
    }

    private String getSchemaUrlName(String wsdlUrl, String schemaName) {
        int index = wsdlUrl.lastIndexOf("/");
        if (index >= 0) {
            return wsdlUrl.substring(0, index + 1) + schemaName;
        }
        return null;
    }

    private void setState(int newState) {
        this.status = newState;
        this.log(STATUS_MESSAGE[newState]);
        SwingUtilities.invokeLater(new MessageSender(this.receiver, STATUS_MESSAGE[newState]));
    }

    private void setState(int newState, String msg, Exception ex) {
        this.status = newState;
        Object[] args = new Object[]{msg, ex.getMessage()};
        String message = MessageFormat.format(STATUS_MESSAGE[newState], args);
        this.log(message);
        SwingUtilities.invokeLater(new MessageSender(this.receiver, message));
    }

    private void log(String message) {
    }

    private WsdlInfo getWsdlInfo() {
        WsdlInfo result = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            ServiceNameParser handler = new ServiceNameParser();
            saxParser.parse(new InputSource(new ByteArrayInputStream(this.wsdlContent)), (DefaultHandler)handler);
            result = new WsdlInfo(handler.getServiceNameList(), handler.getSchemaNames());
        }
        catch (ParserConfigurationException ex) {
        }
        catch (SAXException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private void setRetrieverTrustManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                if (certs != null) {
                    for (int i = 0; i < certs.length; ++i) {
                        DialogDescriptor desc = new DialogDescriptor((Object)Retriever.getCertificationPanel((X509Certificate)certs[i]), NbBundle.getMessage(WsdlRetriever.class, (String)"TTL_CertifiedWebSite"), true, 0, DialogDescriptor.YES_OPTION, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        if (DialogDescriptor.YES_OPTION.equals(desc.getValue())) continue;
                        throw new CertificateException(NbBundle.getMessage(WsdlRetriever.class, (String)"ERR_NotTrustedCertificate"));
                    }
                }
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            });
        }
        catch (GeneralSecurityException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public static class SchemaInfo {
        private String schemaName;
        private byte[] schemaContent;

        SchemaInfo(String schemaName, byte[] schemaContent) {
            this.schemaName = schemaName;
            this.schemaContent = schemaContent;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public byte[] getSchemaContent() {
            return this.schemaContent;
        }
    }

    private static class WsdlInfo {
        private List<String> serviceNameList;
        private List<String> schemaNames;

        WsdlInfo(List<String> serviceNameList, List<String> schemaNames) {
            this.serviceNameList = serviceNameList;
            this.schemaNames = schemaNames;
        }

        List<String> getSchemaNames() {
            return this.schemaNames;
        }

        List<String> getServiceNameList() {
            return this.serviceNameList;
        }
    }

    private static class Chunk {
        private int length;
        private byte[] data;

        public Chunk(byte[] d, int l) {
            this.data = d;
            this.length = l;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getLength() {
            return this.length;
        }
    }

    private static final class ServiceNameParser
    extends DefaultHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        private List<String> serviceNameList = new ArrayList<String>();
        private List<String> schemaNames = new ArrayList<String>();
        private boolean insideSchema;

        ServiceNameParser() {
        }

        @Override
        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            String schemaLocation;
            if (W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) {
                String wsdlLocation;
                if ("service".equals(localname)) {
                    this.serviceNameList.add(attributes.getValue("name"));
                }
                if ("types".equals(localname)) {
                    this.insideSchema = true;
                }
                if ("import".equals(localname) && (wsdlLocation = attributes.getValue("location")) != null && wsdlLocation.indexOf("/") < 0 && wsdlLocation.endsWith(".wsdl")) {
                    this.schemaNames.add(wsdlLocation);
                }
            }
            if (this.insideSchema && "import".equals(localname) && (schemaLocation = attributes.getValue("schemaLocation")) != null && schemaLocation.indexOf("/") < 0 && schemaLocation.endsWith(".xsd")) {
                this.schemaNames.add(schemaLocation);
            }
        }

        @Override
        public void endElement(String uri, String localname, String qname) throws SAXException {
            if ((W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) && "types".equals(localname)) {
                this.insideSchema = false;
            }
        }

        public List<String> getServiceNameList() {
            return this.serviceNameList;
        }

        public List<String> getSchemaNames() {
            return this.schemaNames;
        }
    }

    public static interface MessageReceiver {
        public void setWsdlDownloadMessage(String var1);
    }

    private static class MessageSender
    implements Runnable {
        private MessageReceiver receiver;
        private String message;

        public MessageSender(MessageReceiver r, String m) {
            this.receiver = r;
            this.message = m;
        }

        @Override
        public void run() {
            this.receiver.setWsdlDownloadMessage(this.message);
        }
    }
}

